classdef (ConstructOnLoad) TransientsMethod < siman.FeatureDetectionMethod
    % TransientsDefinition.
    properties (Constant)
        DerivativeThresholdTypeOptions = {'image units', 'percentile'};
    end
    properties (GetObservable, SetObservable) % Registered properties
        DerivativeThresholdType = 'percentile';
        DerivativeThreshold_DataUnits = 10;
        DerivativeThreshold_Percentile = 99;
        DerivativeThreshold_Actual;
        DetectionMedianFilterWidth = 5;
        WaveformStartOffset = -10;
        WaveformStopOffset = 100;
        RefractoryLimit = 50;
        UnitsMedianFilterWidth = 3;
    end
    
    methods
        % Constructor
        function obj = TransientsMethod()
            obj@siman.FeatureDetectionMethod();
        end
            
        function InitMethod(obj)
            obj.FeatureType = 'transient';
            obj.DetectionDefName = 'transient detection';
            obj.UnitsDefName = 'transient units';

            obj.DetectionMethodOptions = {'derivative'};
        end
        
        function OnPropertyChanged(obj, src, evnt)
            OnPropertyChanged@siman.FeatureDetectionMethod(obj, src, evnt);
            % Indicate need for layout change
            switch evnt.PropertyName
                case {'DerivativeThresholdType'}
                    notify(obj, 'MethodLayoutChange');
            end
        end
        
        function def = GetDefaultDetectionDefinition(obj)
            def = GetDefaultDetectionDefinition@siman.FeatureDetectionMethod(obj);
        end
            
        function def = GetDefaultUnitsDefinition(obj)
            def = GetDefaultUnitsDefinition@siman.FeatureDetectionMethod(obj);
        end
    end
end





