classdef CommandManager < handle
    properties
        CommandList
    end
    
    methods
        % Constructor
        function obj = CommandManager()
            obj.CommandList = siman.List;
        end
        
        function cmd = RegisterCommand(obj, name, controller)
            existingCmd = obj.FindCommand(name, controller);
            if ~isempty(existingCmd)
                siman.Debug.ReportProblem(['Attempt to register command that already exists: ' name]);
                cmd = [];
                return
            end
            cmd = siman.Command(name, controller);
            obj.CommandList.Add(cmd);
        end
        
        function cmd = FindCommand(obj, name, controller)
            for i = 1:obj.CommandList.Count
                command = obj.CommandList.ElementAt(i);
                if strcmp(name, command.Name)
                    if nargin < 3 || isempty(controller)
                        cmd = command;
                        return;
                    end
                end
            end
            cmd = [];
        end
        
        function RemoveCommand(obj, name)
            command = obj.FindCommand(name);
            if ~isempty(command)
                obj.CommandList.Remove(command);
            end
        end
        
        function ClearCommands(obj, controller)
            if nargin < 2
                controller = [];
            end
            if isempty(controller)
                for i = 1:obj.CommandList.Count
                    command = obj.CommandList.ElementAt(i);
                    delete(command);
                end
                obj.CommandList.Clear();
                return
            end
            for i = obj.CommandList.Count:-1:1
                command = obj.CommandList.ElementAt(i);
                if isempty(controller) || isequal(command.Controller, controller)
                    obj.CommandList.Remove(command);
                    delete(command);
                end
            end
            
        end
        
        function delete(obj)
            delete(obj.CommandList);
            obj.CommandList = [];
        end
    end
end