classdef CellDefPanel < siman.ToolPanel
    % CellDefPanel
    properties (Transient)
        MainSubpanelID
        MessageAxesID
        
        CellDef
        CellDefListener
    end
    
    methods
        % Constructor
        function obj = CellDefPanel(parent)
            obj@siman.ToolPanel(parent);
        end
        
        function InitDefaults(obj)
            obj.Name = 'Cell Definition';
            obj.Size = [260 220];
            obj.DockedLocation = 'east';
        end
        
        function InitPanel(obj)
            InitPanel@siman.ToolPanel(obj);
        end
        
        function OnAttachedPlotChanged(obj, type)
            if ~strcmp(type, 'definition')
                obj.ResetCurrentCellDef();
            end
        end
        
        function ResetCurrentCellDef(obj)
            if isempty(obj.CurrentAttachedPlot)
                obj.SetCellDef([]);
                return;
            end
            source = obj.CurrentAttachedPlot.RawDataSource;
            if isempty(source)
                obj.SetCellDef([]);
                return;
            end
            def = source.CellDefinition;
            obj.SetCellDef(def);
        end
        
        function SetCellDef(obj, def)
            if isempty(def) && isempty(obj.CellDef)
                return;
            end
            if length(def) ~= length(obj.CellDef) || def ~= obj.CellDef
                if ~isempty(obj.CellDefListener)
                    delete(obj.CellDefListener);
                    obj.CellDefListener = [];
                end
                obj.CellDef = def;
                if ~isempty(def)
                    obj.CellDefListener = addlistener(def, 'CellDefinitionChange', @obj.OnCellDefChanged);
                    obj.CellDefListener(2) = addlistener(def, 'MethodLayoutChange', @obj.OnMethodLayoutChanged);
                end
                obj.QueueLayout();
                obj.SetPanelDataSource(def);
            end
        end
        
        function OnCellDefChanged(obj, src, evt)
            obj.QueueLayout(); %TODO should just do a refresh if not a layout change
        end
        
        function OnMethodLayoutChanged(obj, src, evt)
            obj.QueueLayout();
        end
        
        function Redraw(obj)
            obj.RefreshControls();
        end
        
        function ResetLayout(obj)
            obj.MakeControls();
        end
        
        function enabling = GetEnabling(obj, id, prop, context)
            enabling = true;
        end
    end
end


