function mask = GetMask(obj)

import siman.*;
source = obj.DataSource;

if strcmp(obj.Type, 'none')
    mask = [];
    return
end

switch obj.Orientation
    case 'linescan'
        mask = GetLinescanMask(obj, source);  
    case '2-d'
        mask = Get2DMask(obj, source);  
end
end

function mask = GetLinescanMask(obj, source)
    dim = source.Size;
    if ~obj.IsValid
        mask = ones(dim([2 1]));
        return
    end
    lowerEdge = obj.LowerEdge;
    upperEdge = obj.UpperEdge;
    mask = zeros(dim([2 1]));
    mask(:, lowerEdge:upperEdge) = 1;
end

function mask = Get2DMask(obj, source)
    dim = source.Size;
    if ~obj.IsValid
        mask = ones(dim([2 1]));
        return
    end
    mask = obj.CellMask;
end