function MakeControls(obj)

import siman.*;
parentPanel = obj.PanelID;
margin = 8;
parentPos = get(parentPanel, 'Position');
top = parentPos(4)-margin-siman.UIHelper.PANEL_TOP_OFFSET;
source = obj.CurrentFeatureSource;
manager = siman.ContractionManager.Instance;

children = get(parentPanel, 'Children');
delete(children);

controlParams.ParentPanel = parentPanel;
controlParams.DataObject = obj;
controlParams.Controller = obj;

location = [margin top];

if isempty(source)
    siman.UIHelper.MakeLabel(['No ' obj.FeatureType ' source'], ...
                    location, controlParams);
    return
end

bottomOffset = margin + siman.UIHelper.TOOLBAR_BUTTON_HEIGHT + 5;
width = parentPos(3)-2*margin;
height = parentPos(4)-siman.UIHelper.TEXT_HEIGHT-siman.UIHelper.VERTICAL_SPACING-margin-bottomOffset;
graphPos = [margin bottomOffset width height]; 
obj.GraphAxesID = axes('Parent', parentPanel, 'Units', 'pixels', ...
    'Tag', 'FeatureGraph', 'OuterPosition', graphPos);
graphPos = get(obj.GraphAxesID, 'Position'); % get inner position



location = [graphPos(1)+graphPos(3) graphPos(2)+graphPos(4)];
controlParams.Callback = []; % clear setting for next controls
controlParams.RefreshCallback = [];
controlParams.LocationType = 'lower right';

prefix = manager.CommandPrefix;
controlParams.CommandName = [prefix 'CopyAllFeatureData'];
controlParams.Context = obj;
location = siman.UIHelper.MakeToolbarButton(location, controlParams);



% ctxMenu = uicontextmenu('Tag', 'ContextMenu');
% set(obj.GraphAxesID, 'UIContextMenu', ctxMenu);
% uimenu(ctxMenu, 'Label', 'Copy Selected', 'Tag', 'CopySelected', ...
%     'Callback', buttonCallback);
% uimenu(ctxMenu, 'Label', 'Copy All', 'Tag', 'CopyAllFeatureTraces', ...
%     'Callback', buttonCallback);

