function InitCommands(obj)

% These commands require a context with a OnManagerSourcesOpened(sources) method
cmd = obj.RegisterCommand('File.OpenImageFiles', obj);
cmd.Label = '+';
cmd.Tooltip = 'Open one or more files containing images';

cmd = obj.RegisterCommand('File.OpenImageDirectory', obj);
cmd.Label = '+';
cmd.Tooltip = 'Open a directory of image files as an image series';


% These commands require a context that provides a ProcessingDef and a CurrentOperation
cmd = obj.RegisterCommand('ProcessingDef.InsertOperation', obj);
cmd.Label = '+';
cmd.Tooltip = 'Insert new operation after selected one';

cmd = obj.RegisterCommand('ProcessingDef.DeleteOperation', obj);
cmd.Label = '-';
cmd.Tooltip = 'Delete selected operation';

cmd = obj.RegisterCommand('ProcessingDef.MoveUpOperation', obj);
cmd.Label = 'Up';
cmd.Tooltip = 'Move the selected operation up (swap with previous operation)';

cmd = obj.RegisterCommand('ProcessingDef.MoveDownOperation', obj);
cmd.Label = 'Dn';
cmd.Tooltip = 'Move the selected operation down (swap with following operation)';

cmd = obj.RegisterCommand('ProcessingDef.SkipOperation', obj);
cmd.Label = 'o';
cmd.Tooltip = 'Skip the selected operation';

cmd = obj.RegisterCommand('ProcessingDef.StopOperation', obj);
cmd.Label = 'x';
cmd.Tooltip = 'Stop the processing on the selected operation';

cmd = obj.RegisterCommand('ProcessingDef.ChangeOperationType', obj);
cmd.Label = 'c';
cmd.Tooltip = 'Change the type of the selected operation';

