function InitProcessingDefs(obj)

InitRawDef(obj);

filename = fullfile(siman.FileIOHelper.GetSimanPath(), obj.StoredDefinitionsFilename);
if ~exist(filename, 'file')
    InitDefaultDefs(obj);
    return % No stored definitions yet
end
[ok, message, defList] = siman.FileIOHelper.LoadSimanFile(filename);
if ~ok
    warndlg(['Could not initialize user definitions: ' message], 'I/O Error', 'modal');
    InitDefaultDefs(obj);
    return
end
if ~isa(defList, 'siman.ObservableCollection') && ~isa(defList, 'siman.List')
    warndlg('Invalid stored definitions.  Reverting to factory defaults.', 'Internal Error', 'modal');
    InitDefaultDefs(obj);
    return
end
if defList.Count == 0
    warndlg('Stored definition array is empty.  Reverting to factory defaults.', 'Internal Error', 'modal');
    InitDefaultDefs(obj);
    return
end
for i = 1:defList.Count
    def = defList.ElementAt(i);
    if ~isa(def, 'siman.ProcessingDefinition')
        warndlg('Bad definition in stored list.  Reverting to factory defaults.', 'Internal Error', 'modal');
        InitDefaultDefs(obj);
        return
    end
end
for i = 1:defList.Count
    def = defList.ElementAt(i);
    obj.RegisterDefinition(def);
end

end
   


function InitRawDef(obj)
    list = obj.ProcessingDefs;
    if isempty(list)
        list = siman.List;
        obj.ProcessingDefs = list;
    end
    def = siman.ProcessingDefinition;
    def.Name = 'raw';
    def.IsSystemDefinition = true;
    list.Add(def);
end

function InitDefaultDefs(obj)
    def = siman.ProcessingDefinition;
    def.Name = 'testing 2d';
    def.AddOperation('subtract background');
    def.AddOperation('median filter');
    def.AddOperation('calculate baseline');
    def.AddOperation('baseline normalization');
    obj.RegisterDefinition(def);

    def = siman.ProcessingDefinition;
    def.Name = 'testing 3d';
    def.AddOperation('swap dimensions');
    obj.RegisterDefinition(def);

end
