function StoreProcessingDefs(obj)

list = obj.ProcessingDefs;

storageList = siman.List;
for i = 1:list.Count
    def = list.ElementAt(i);
    if ~def.IsSystemDefinition
        storageList.Add(def);
    end
end

filename = fullfile(siman.FileIOHelper.GetSimanPath(), obj.StoredDefinitionsFilename);
[ok, message] = siman.FileIOHelper.WriteSimanFile(filename, storageList);
if ~ok
    warndlg(['Could not save user definitions: ' message], 'I/O Error', 'modal');
    return
end
