function DrawImage(obj)

def = obj.CurrentProcessingDef;
data = obj.ProcessedData;

if isempty(data)
    id = obj.ImageID;
    if ~isempty(id)
        if ishandle(id)
            delete(id);
        end
        obj.ImageID = [];
    end
    return;
end

dim = size(data);
if numel(dim) > 2 && ~def.IsRGB
    frameIndex = obj.FrameIndex;
    if isempty(frameIndex)
        frameIndex = 1;
    elseif frameIndex < 1
        frameIndex = 1;
    elseif frameIndex > dim(3)
        frameIndex = dim(3);
    end
    data = data(:,:,frameIndex);
end
switch obj.Direction
    case 'top-bottom'
    case 'left-right'
        data = data';
    case 'bottom-top'
    case 'right-left'
end

obj.FullImage = data;

obj.ImageSize = dim;
xRange = round(obj.ViewImageXRange);
%xRange = round(obj.GetDataXRange());
%xRange(1) = max(1, xRange(1)-1);
%xRange(2) = min(dim(2), xRange(2)+1);
yRange = round(obj.ViewImageYRange);
%yRange = round(obj.GetDataYRange());
%yRange(1) = max(1, yRange(1)-1);
%yRange(2) = min(dim(1), yRange(2)+1);
if def.IsRGB
    if isempty(obj.ImageID)
        obj.ImageID = imshow(data, 'Parent', obj.AxesID);
    else
    end
else
    imageCutout = data(yRange(1):yRange(2), xRange(1):xRange(2));
    if isempty(obj.ImageID) || ~ishandle(obj.ImageID)
        obj.ImageID = image('Parent', obj.AxesID, 'CData', imageCutout, 'CDataMapping', 'scaled');
        %enterFcn = @(figHandle, currentPoint)...
        %    set(figHandle, 'Pointer', 'crosshair');
        %exitFcn = @(figHandle, currentPoint)...
        %    set(figHandle, 'Pointer', 'arrow');
        %pointerBehavior.enterFcn    = enterFcn;
        %pointerBehavior.exitFcn     = [];%exitFcn;
        %pointerBehavior.traverseFcn = []; %@overMe;    
        %iptSetPointerBehavior(obj.ImageID, pointerBehavior);
        %iptPointerManager(gcf);    
    else
        set(obj.ImageID, 'CData', imageCutout);
    end
end
set(obj.ImageID, 'XData', xRange, 'YData', yRange);




