function RecreateImage(obj)

import siman.*;
obj.ProcessedData = [];
obj.FrameCount = 1;
obj.FullDataSize = [];

cla(obj.MessageAxesID);
source = obj.RawDataSource;
if isempty(source)
    obj.ErrorMessage = 'No image source';
    obj.SetNoticeMessage(obj.ErrorMessage, siman.UIHelper.MESSAGE_INFO);
    return;
end
if ~isvalid(source)
    obj.ErrorMessage = 'Image source object has been deleted';
    obj.SetNoticeMessage(obj.ErrorMessage, siman.UIHelper.MESSAGE_ERROR);
    return;
end
if ~source.IsValid
    obj.ErrorMessage = source.ErrorMessage;
    obj.SetNoticeMessage(obj.ErrorMessage, siman.UIHelper.MESSAGE_ERROR);
    return;
end
def = obj.CurrentProcessingDef;
if ~def.IsValid
    obj.ErrorMessage = def.ErrorMessage;
    if isempty(obj.ErrorMessage)
        obj.ErrorMessage = 'Undefined error in processing definition';
    end
    obj.SetNoticeMessage(obj.ErrorMessage, siman.UIHelper.MESSAGE_ERROR);
    return;
end

obj.SetNoticeMessage('Creating image...', siman.UIHelper.MESSAGE_INFO);
processedData = def.ProcessSource(source);
obj.ProcessedData = processedData;
[minval, maxval] = minmax(processedData);
obj.ImageDataLimits = [minval maxval];
dim = size3d(processedData);
obj.FrameCount = dim(3);
obj.ResetFullDataSize();%TODO optimize this
if obj.FrameCount == 1
    obj.FrameIndex = 1;
end
cla(obj.MessageAxesID);
