classdef ImageSource < siman.SimanObject
    % Must be a subclass of handle
    properties (SetObservable = true)
        Name = '';
        ShortName = '';
    end
    properties
        Width
        Height
        ImageCount
        BitDepth
        ColorType
        DataType
        
        DataLayout
        
        ErrorMessage
    end
    properties (Dependent = true)
        IsValid
        IsSeries
        IsRGB
        
        Size
    end
    properties (Abstract = true)
        IsLoaded
    end
    events
        DataChanged
    end
    
    methods % Properties
        function value = get.IsValid(obj)
            value = isempty(obj.ErrorMessage);
        end
        function value = get.IsSeries(obj)
            value = obj.ImageCount > 1;
        end
        function value = get.IsRGB(obj)
            value = strcmp(obj.ColorType, 'truecolor');
        end
        function value = get.Size(obj)
            if ~obj.IsValid
                value = [];
                return;
            end
            if obj.IsSeries
                value = [obj.Width obj.Height obj.ImageCount];
            else
                value = [obj.Width obj.Height obj.ImageCount];
            end
        end
        
    end
    
    methods
        % Constructor
        function obj = ImageSource()
            obj@siman.SimanObject();
        end
        
        function SetErrorState(obj, state, message)
            if state
                obj.ErrorMessage = message;
                obj.FireDataChanged('error');
            else
                obj.ErrorMessage = '';
            end
        end
        
        function FireDataChanged(obj,type)
            notify(obj, 'DataChanged', siman.DataChangedEventData(type));
        end
    end
    methods (Abstract = true)
        data = GetData(obj);
        image = GetImage(obj, index);
    end
end