classdef Notifier < matlab.mixin.Copyable
    % Must be a subclass of handle
    properties (Transient)
        NotificationPropertyListeners
        NotificationActive = true;
        SelfListener
    end
    events
        PropertyChanged
    end
    methods
        function obj = Notifier()
            obj@matlab.mixin.Copyable();
            
            obj.InitPropertyListeners();
        end
        
        function InitPropertyListeners(obj)
            info = metaclass(obj);
            props = info.PropertyList;
%             indexes = false(length(props), 1);
%             names = cell(length(props), 1);
%             for i = 1:length(props)
%                 if props{i}.SetObservable
%                     indexes(i) = true;
%                     names{i} = props{i}.Name;
%                 end
%             end
            propsToListenFor = props([props.SetObservable]);
            listeners = addlistener(obj,propsToListenFor,'PostSet',@obj.HandlePropertyChanged);
            obj.NotificationPropertyListeners = listeners;
        end
        
%         function InitPropertyListeners(obj)
%             info = metaclass(obj);
%             props = info.Properties;
%             listeners = [];
%             indexes = zeros(length(props), 1);
%             for i = 1:length(props)
%                 if props{i}.SetObservable
%                     if isempty(listeners)
%                         listeners = addlistener(obj,props{i}.Name,'PostSet',@obj.HandlePropertyChanged);
%                     else
%                         listeners(end + 1) = addlistener(obj,props{i}.Name,'PostSet',@obj.HandlePropertyChanged);
%                     end
%                 end
%             end
%             obj.NotificationPropertyListeners = listeners;
%         end
        
        function HandlePropertyChanged(obj, src, evnt)
            if isvalid(obj) && obj.NotificationActive && ~siman.FileIOHelper.GetHelper().IsLoading
                notify(obj, 'PropertyChanged', siman.PropertyChangedEventData(src.Name));
            end
        end
        
        function delete(obj)
            delete(obj.NotificationPropertyListeners);
            obj.NotificationPropertyListeners = [];
            if ~isempty(obj.SelfListener)
                delete(obj.SelfListener);
                obj.SelfListener = [];
            end
        end
    end
    
    methods(Access = protected)
        % Override copyElement method:
        function cpObj = copyElement(obj)
            % Make a shallow copy of all properties
            cpObj = copyElement@matlab.mixin.Copyable(obj);
            % Reset the listeners (since they don't copy)
            cpObj.InitPropertyListeners();
        end
    end
end
