function result = subsref(obj, format)
%subsref - Overload to allow direct subscripting of collections
    if ~strcmp(format(1).type, '()')
        error('Siman:BadCollectionSyntax', 'Bad indexing for collection.  Only () supported.')
    end
    
    % obj(:).fieldname syntax (returns a cell array of values and errors if
    % not all objects have that field)
    if ischar(format(1).subs) && strcmp(format(1).subs, ':')
        if length(format) == 2
            error('Siman:BadCollectionSyntax', 'Bad indexing for collection.  Only (:).(field) supported.')
        end
        if ~strcmp(format(2).type, '.')
            error('Siman:BadCollectionSyntax', 'Bad indexing for collection.  Only (:).(field) supported.')
        end
        fieldname = format(2).subs;
        count = obj.Count;
        result = cell(count);
        for i = 1:count
            element = obj.ElementAt(i);
            if ~isprop(element, fieldname)
                error('Siman:InvalidCollectionElementProp', ['Collection element does not have property:' fieldname])
            end
            result{i} = element.(fieldname);
        end
    end
    result = obj.ElementAt(format(1).subs);
    if length(format) > 1
        result = subsref(result, format(2:end));
    end
end

