function ResetOperationControls(obj)

import siman.*;

opSubpanelID = obj.OperationSubpanelID;
h = get(opSubpanelID, 'Children');
delete(h);

currentOp = obj.CurrentOperation;
def = obj.ProcessingDef;

cla(obj.MessageAxesID);
if isempty(def)
    text(.5, .5, 'No image definition', 'Parent', obj.MessageAxesID, ...
        'HorizontalAlignment', 'center', 'FontSize', 16, 'FontAngle', 'italic', ...
        'Color', [.5 .5 .5]);
    set(opSubpanelID, 'Title', '');
    return
end
if def.OperationCount == 0
    text(.5, .5, 'No operations', 'Parent', obj.MessageAxesID, ...
        'HorizontalAlignment', 'center', 'FontSize', 16);
    set(opSubpanelID, 'Title', '');
    return
end
if isempty(currentOp)
    text(.5, .5, 'No operation selected', 'Parent', obj.MessageAxesID, ...
        'HorizontalAlignment', 'center', 'FontSize', 16, 'FontAngle', 'italic');
    set(opSubpanelID, 'Title', '');
    return
end


type = currentOp.Type;
set(opSubpanelID, 'Title', type);
currentOp.MakeControls(opSubpanelID);

if currentOp.IsValid
    return;
end

pos = get(opSubpanelID, 'Position');
location = [10 10];
controlParams.ParentPanel = opSubpanelID;
controlParams.ForegroundColor = [1 0 0];
controlParams.Width = pos(3)-20;
controlParams.LocationType = 'lower left';
controlParams.DataObject = currentOp;
controlParams.Controller = currentOp;
siman.UIHelper.MakeIndicator('ErrorMessage', location, controlParams);
