function [valid, message] = Validate(obj)

import siman.*;
message = '';

obj.BaselineOperation = [];

ops = obj.GetActiveOperations();
count = ops.Count;
for i = 1:count
    op = ops.ElementAt(i);
    [valid, message] = op.Validate(obj);
    if ~valid
        op.ErrorMessage = message;
        op.IsValid = false;
        obj.ErrorMessage = message;
        return
    end
    if (~op.IsValid)
        op.IsValid = true;
    end
    if (~isempty(op.ErrorMessage))
        op.ErrorMessage = '';
    end
    if strcmp(op.Type, 'calculate baseline')
        obj.BaselineOperation = op;
    end
end
valid = true;
