function output_size = GetOutputSize(obj, input_size)
% x, y, z size of data (not row, col, z)

import siman.*;

type = obj.Type;
switch type
    case 'swap dimensions'
        switch obj.SwapDimensions
            case 'y,z'
                output_size = input_size([1 3 2]);
        end
    case 'collapse dimension'
        switch obj.CollapseDimension
            case 'z'
                output_size = input_size([1 2]);
        end
    case 'calculate baseline'
        switch obj.BaselineResultAction
            case 'calculate only'
                output_size = input_size;
            case {'baseline image', 'std dev image'}
                if ismember(obj.BaselineCalcMethod, {'sliding region', 'rolling ball'})
                    output_size = input_size;
                else
                    output_size = input_size([1 2]);
                end
        end
    otherwise
        output_size = input_size; % just to keep from crashing
end