classdef ROIManager < handle
    % ROIManager
    properties (Constant)
       CommandPrefix = 'Tools.ROI.';
    end
    methods
        % Constructor
        function obj = ROIManager()
            obj.InitCommands();
        end
        
    end
    
    methods
        function InitCommands(obj)
            mgr = siman.ImageManager.GetManager();
            if isempty(mgr)
                return
            end

            % These commands need a context with a GetROIList and GetSelectedROIsList method
            cmd = mgr.RegisterCommand([obj.CommandPrefix 'CopyAllROIs'], obj);
            cmd.Label = 'c';
            cmd.Tooltip = ['Copy all roi properties of the currently selected image'];
            
            cmd = mgr.RegisterCommand([obj.CommandPrefix 'ExportAllROIs'], obj);
            cmd.Label = 'e';
            cmd.Tooltip = ['Export all roi properties of the currently selected image to a file'];
            
            cmd = mgr.RegisterCommand([obj.CommandPrefix 'ClearAllROIs'], obj);
            cmd.Label = '-';
            cmd.Tooltip = ['Delete all roi''s of the image'];
            
            cmd = mgr.RegisterCommand([obj.CommandPrefix 'DeleteSelectedROIs'], obj);
            cmd.Label = '-';
            cmd.Tooltip = ['Delete selected roi''s of the image'];
            
            cmd = mgr.RegisterCommand([obj.CommandPrefix 'CopyAllROIData'], obj);
            cmd.Label = 'c';
            cmd.Tooltip = ['Copy the data of all roi''s of the currently selected image'];
            
        end
        
        function OnCommand(obj, cmd, ~, context) % id is missing argument
            prefix = obj.CommandPrefix;
            switch cmd.Name
                case [prefix 'CopyAllROIs']
                    list = context.GetROIList();
                    context.CurrentROISource.CopyROIProps(list);
                case [prefix 'CopySelectedROIs']
                    list = context.GetSelectedROIList();
                    context.CurrentROISource.CopyROIProps(list);
                case [prefix 'ExportAllROIs']
                case [prefix 'CopyAllROIData']
                    list = context.GetROIList();
                    context.CurrentROISource.CopyROIData(list);
                case [prefix 'CopySelectedROIData']
                    list = context.GetSelectedROIList();
                    context.CurrentROISource.CopyROIData(list);
                case [prefix 'ClearAllROIs']
                    choice = questdlg('Are you sure you want to delete all roi(s)?', ...
                        'Confirm delete', 'Yes', 'No', 'Cancel', 'Cancel');
                    if strcmp(choice, 'Yes')
                        context.CurrentROISource.ClearAllROIs();
                    end
                case [prefix 'DeleteSelectedROIs']
                    choice = questdlg('Are you sure you want to delete the selected roi(s)?', ...
                        'Confirm delete', 'Yes', 'No', 'Cancel', 'Cancel');
                    if strcmp(choice, 'Yes')
                        context.CurrentROISource.RemoveSelectedROIs(obj.ROIType);
                    end
                case [prefix 'SelectROIs']
                    list = context.GetSelectedROIList();
                    context.CurrentROISource.CopyROIData(list);
                otherwise
                    siman.Debug.ReportProblem(['Unknown roi command to execute: ' cmd.Name]);
            end
        end
        
        function enabling = ResetCommandEnabling(obj, cmd, context)
            prefix = obj.CommandPrefix; % This just makes cross-roi copy/paste of code easier
            if isempty(context.CurrentROISource)
                enabling = false;
                return;
            end
            switch cmd.Name
                case [prefix 'CopyAllROIs']
                    list = context.CurrentROISource.ROIList;
                    enabling = list.Count > 0;
                case [prefix 'CopySelectedROIs']
                    list = context.CurrentROISource.SelectedROIList;
                    enabling = ~isempty(list) && list.Count > 0;
                case [prefix 'ExportAllROIs']
                    list = context.CurrentROISource.ROIList;
                    enabling = ~isempty(list) && list.Count > 0;
                case [prefix 'CopyAllROIData']
                    list = context.CurrentROISource.ROIList;
                    enabling = ~isempty(list) && list.Count > 0;
                case [prefix 'CopySelectedROIData']
                    list = context.CurrentROISource.SelectedROIList;
                    enabling = ~isempty(list) && list.Count > 0;
                case [prefix 'DeleteSelectedROIs']
                    list = context.CurrentROISource.SelectedROIList;
                    enabling = ~isempty(list) && list.Count > 0;
                case [prefix 'ClearAllROIs']
                    list = context.CurrentROISource.ROIList;
                    enabling = ~isempty(list) && list.Count > 0;
                otherwise
                    siman.Debug.ReportProblem(['Unknown roi command to enable: ' cmd.Name]);
                    enabling = false;
            end
        end
        
        function ApplyChanges(obj)
        end
        
        function tf = HasPendingChanges(obj)
            tf = false;
        end
        
    end
end





