classdef SparkManager < siman.FeatureManager
    % SparkManager.
    properties (Constant)
        Instance = siman.SparkManager; % Singleton object
        
        CommandPrefix = 'Spark.';
        FeatureType = 'spark';
    end
     
    methods (Access = private)
        % Constructor
        function obj = SparkManager()
            obj@siman.FeatureManager();
            
            % For development case where file was edited and the instance was deleted
            mgr = siman.ImageManager.GetManager();
            if isempty(mgr)
                return
            end
            
            obj.SourceArchivingProperty = 'LastSparkDetectionMethod';
            if isempty(obj.FeatureDetectionMethod)
                obj.FeatureDetectionMethod = siman.SparksMethod;
            end
        end
        
    end
        
    methods (Static = true)
        function mgr = GetManager()
            mgr = siman.SparkManager.Instance;
        end
    end
end





