classdef SparkletSiteGraphPanel < siman.FeatureGraphPanel
    % SparkletSiteGraphPanel
    
    properties (Transient)
        ThumbnailAxesID
    end
    
    methods
        % Constructor
        function obj = SparkletSiteGraphPanel(parent)
            obj@siman.FeatureGraphPanel(parent, 'sparklet site');
        end
        
        function mgr = GetManager(obj)
            mgr = siman.SparkletSiteManager.Instance;
        end
        
        function InitDefaults(obj)
            obj.Name = 'Sparklet Site Graph';
            obj.Size = [260 280];
            obj.DockedLocation = 'south';
            obj.Stretchable = true;
            InitDefaults@siman.FeatureGraphPanel(obj);
        end
        
        % Handle enabling of controls tied to a local property
        function enabling = GetEnabling(obj, id, prop, context)
            enabling = true;
        end
        
    end
end


