classdef Debug < handle
    % Debug - A singleton class for handling error conditions.
    properties (Constant)
        Instance = siman.Debug;
        LogFilename = 'ErrorLog.txt';
    end
    properties (Access = private)
        IsDebugging = true; %TODO Only works with instance
    end
    methods (Static = true)
        function ReportError(ex, message)
            siman.Debug.WriteLine(['**Reporting error: ' message]);
            siman.Debug.WriteLine(['    ' ex.identifier ' -- ' ex.message]);
            for i = 1:length(ex.stack)
                stackItem = ex.stack(i);
                siman.Debug.WriteLine(['     -' stackItem.name ' (' num2str(stackItem.line) ')']);
            end
        end
        function ReportProblem(message)
            siman.Debug.WriteLine('**Reporting problem:');
            siman.Debug.WriteLine(['    ' message]);
        end
        function Assert(test, type, message)
            if ~test
                siman.Debug.Fail(type, message);
            end
        end
        function Fail(type, message)
            siman.Debug.WriteLine('**Debug Assertion failed');
            siman.Debug.WriteLine(message);
            siman.Debug.Throw(type, message);
        end
        function WriteLine(string, file_only)
            if nargin < 2
                file_only = false;
            end
            fullpath = fullfile(siman.FileIOHelper.GetSimanPath(), siman.Debug.LogFilename);
            [fid, message] = fopen(fullpath, 'a');
            fprintf(fid, [datestr(now) '   ' string '\r\n']);
            fclose(fid);
            if ~file_only
                disp(string);
            end
        end
        function Throw(type, message)
            exception = MException(['SIMAN:' type], message);
            throw(exception);
        end
    end
end





