function bounded_vals = bounded( vals, minVal, maxVal, margin )

if nargin < 4
    margin = 0;
end
if nargin < 3
    error('utils:badArguments', 'bounds() requires at least 3 input arguments');
end
count = length(vals);
bounded_vals = vals;
for i = 1:count
    bound = minVal + margin;
    bounded_vals(i) = max(bounded_vals(i), bound);
    bound = maxVal - margin;
    bounded_vals(i) = min(bounded_vals(i), bound);    
end
