classdef (ConstructOnLoad) ContractionMethod < siman.SimanObject
    % ContractionDefinition.
    properties (Constant)
        FeatureType = 'contraction';
        DetectionDefName = 'contraction detection';
        
        DetectionMethodOptions = {'mean percent'};
    end
    properties
        DetectionDefinition
    end
    properties (Transient)
        DetectionDefListener
    end
    properties (Dependent)
        HasDetectionDefinition
        HasUnitsDefinition
    end
    properties (GetObservable, SetObservable) % Registered properties
        UnitConversion_Width = 1;
        DetectionMethod = 'mean percent';
        CrossSectionMedianFilterWidth = 9;
        ThresholdPercent = 100;
        BinaryFilterWidth = 5;
        EdgeMedianFilterWidth = 5;
    end
    
    events
        MethodChange
        MethodLayoutChange
    end
    
    methods % Properties
        function set.DetectionDefinition(obj, value)
            if isempty(value) % internal code for nulling the property during a copy
                obj.DetectionDefinition = [];
                obj.DetectionDefListener = [];
                return
            end
            if ~isempty(obj.DetectionDefinition)
                delete(obj.DetectionDefinition);
                if ~isempty(obj.DetectionDefListener)
                    delete(obj.DetectionDefListener)
                end
            end
            obj.DetectionDefinition = value;
            if ~isempty(value)
                obj.DetectionDefListener = addlistener(obj.DetectionDefinition, 'DefinitionChange', @obj.OnDefinitionChanged);
            end
        end
        function tf = get.HasDetectionDefinition(obj)
            tf = ~isempty(obj.DetectionDefName);
        end
        function tf = get.HasUnitsDefinition(obj)
            tf = ~isempty(obj.UnitsDefName);
        end
    end
    
    methods
        % Constructor
        function obj = ContractionMethod()
            obj@siman.SimanObject();
            
            obj.InitDefaultDefs();
            obj.InitListeners();
        end     
        
        function InitListeners(obj)
            obj.SelfListener = addlistener(obj, 'PropertyChanged', @obj.OnPropertyChanged);
        end
        
        function OnPropertyChanged(obj, src, evnt)
            switch evnt.PropertyName
                otherwise
                    notify(obj, 'MethodChange');
            end
            % Indicate need for layout change
            switch evnt.PropertyName
                case 'DetectionMethod'
                    notify(obj, 'MethodLayoutChange');
            end
        end
        
        % Handle enabling of controls tied to a local property
        function enabling = GetEnabling(obj, id, prop, context)
            enabling = true;
        end
        
        function InitDefaultDefs(obj)
            if isempty(obj.DetectionDefinition)
                def = siman.ProcessingDefinition;
                def.Name = obj.DetectionDefName;
                def.IsSystemDefinition = true;
                %op = def.AddOperation();
                %op.Type = 'subtract background';
                obj.DetectionDefinition = def;
            end
        end
        
        function ApplyChanges(obj)
            obj.DetectionDefinition.ApplyChanges();
        end
        
        function delete(obj)
            if ~isempty(obj.DetectionDefinition)
                delete(obj.DetectionDefinition);
                delete(obj.DetectionDefListener);
                obj.DetectionDefinition = [];
            end
        end
    end
    
    methods(Access = protected)
        % Override copyElement method:
        function cpObj = copyElement(obj)
            % Make a shallow copy of all properties
            cpObj = copyElement@siman.SimanObject(obj);
            cpObj.InitListeners();
            % Make a deep copy of the definitions
            cpObj.DetectionDefinition = [];
            cpObj.DetectionDefinition = copy(obj.DetectionDefinition);
        end
    end
end





