function InitCommands(obj)

% These commands require a context with a OnManagerSourcesOpened(sources) method
cmd = siman.ImageManager.Instance.RegisterCommand('View.ZoomIn', obj);
cmd.Label = '+';
cmd.Tooltip = 'Double the zoom factor making the image appear larger';

cmd = siman.ImageManager.Instance.RegisterCommand('View.ZoomOut', obj);
cmd.Label = '-';
cmd.Tooltip = 'Halve the zoom factor making the image appear smaller';

cmd = siman.ImageManager.Instance.RegisterCommand('View.LockPlot', obj);
cmd.Label = '-';
cmd.IsCheckable = true;
cmd.Tooltip = 'Lock/unlock the display while making processing changes';

cmd = siman.ImageManager.Instance.RegisterCommand('Window.CloseAllToolPanels', obj);
cmd.Label = 'x';
cmd.Tooltip = 'Close all panels (except the main image panel)';

cmd = siman.ImageManager.Instance.RegisterCommand('Tools.MakeMovie', obj);
cmd.Label = 'm';
cmd.Tooltip = 'Create movie file from image series';



% These commands require a context that provides a ProcessingDef and a CurrentOperation

list = {'ShowInventory', 'ShowImageProp', 'ShowProcessingDef', 'ShowCellDef', 'ShowROIGraph', ...
    'ShowTransientDetection', 'ShowTransientList', 'ShowTransientGraph', ...
    'ShowSparkDetection', 'ShowSparkList', 'ShowSparkGraph', ...
    'ShowSparkletDetection', 'ShowSparkletList', 'ShowSparkletGraph', ...
    'ShowSparkletSiteDetection', 'ShowSparkletSiteList', 'ShowSparkletSiteGraph', ...
    'ShowContractionDetection', 'ShowContractionGraph', ...
    };

tips = {'Show inventory of recently opened images', ...
    'Show list of processing definitions and their operations', ...
    'Show image display options, including color and zoom', ...
    'Show cell definition options', ...
    'Show region of interest data', ...
    'Show transient detection options', ...
    'Show list of transient objects', ...
    'Show graph of transient data', ...
    'Show spark detection options', ...
    'Show list of spark objects', ...
    'Show graph of spark data', ...
    'Show sparklet detection options', ...
    'Show list of sparklet objects', ...
    'Show graph of sparklet data', ...
    'Show sparklet site detection options', ...
    'Show list of sparklet site objects', ...
    'Show graph of sparklet site data', ...
    'Show contraction detection options', ...
    'Show graph of contraction data'};
for i = 1:numel(list)
    cmd = siman.ImageManager.Instance.RegisterCommand(['Window.' list{i}], obj);
    cmd.Label = '+';
    cmd.Tooltip = tips{i};
    cmd.IsCheckable = true;
end

% These commands require a context that provides a CurrentPlot

list = {'File.SaveFullImageAs', 'File.SaveImageStackAs', 'File.SaveVisibleImageAs', ...
    'Edit.CopyFullImage', 'Edit.CopyVisibleImage', ...
    'File.SaveDataAs', 'Edit.CopyData', ...
    'Tools.ROI.AddROIType'};

tips = {'Save full image from the plot as...', ...
    'Save image stack from the current plot as...', ...
    'Save visible image from the current plot as...', ...
    'Copy full image on the current plot', ...
    'Copy visible image on the current plot', ...
    'Save data from the current definition', ...
    'Copy data from the current definition', ...
    'Add region of interest', ...
    'Show colorbar', ...
    };
for i = 1:numel(list)
    cmd = siman.ImageManager.Instance.RegisterCommand(list{i}, obj);
    cmd.Label = '+';
    cmd.Tooltip = tips{i};
end

cmd = siman.ImageManager.Instance.RegisterCommand('View.ShowColorbar', obj);
cmd.Tooltip = 'Show colorbar';
cmd.IsCheckable = true;