classdef Feature < siman.SimanObject
    % Must be a subclass of handle
    properties
        Name
        Type
        Index
    end
    
    properties (SetObservable, GetObservable)
        IsSelected = false;
        IsValid = true;
    end
    
    properties (Transient)
        ErrorMessage
    end
    
    methods
        % Constructor
        function obj = Feature()
            obj@siman.SimanObject();
            obj.IsSelected = false;
        end
        
        function str = GetPropExportString(obj, delim)
            if nargin < 2
                delim = ',';
            end
            str = obj.Name;
            
            propList = obj.GetExportPropList;
            for i = 1:length(propList)
                str = [str delim num2str(obj.(propList{i}))];
            end
        end
    end
    
    methods (Abstract)
        h = Draw(obj, ax, plot);
        str = GetListString(obj);
        str = GetExportPropList(obj);
        result = GetExportData(obj);
        hit = HitTest(obj, area, plot);
        ans = IsInView(obj, area);
        point = CenteredPoint(obj, z);
    end
end







