classdef FeatureGraphPanel < siman.ToolPanel
    % ImagePropPanel
    properties (Transient)
        GraphAxesID        
    end
    properties
        FeatureType;
    end
    properties (SetObservable, GetObservable)
        ViewAll = true;
    end
    properties (Dependent)
        FeatureList
        SelectedFeatureList
    end
    properties (Transient)
        FeatureSourceListener
        CurrentFeatureSource
    end
    
    methods % Properties
        function list = get.FeatureList(obj)
            list = obj.GetFeatureList();
        end
        
        function list = get.SelectedFeatureList(obj)
            list = obj.GetSelectedFeatureList();
        end
    end
    
    methods
        % Constructor
        function obj = FeatureGraphPanel(parent, type)
            obj@siman.ToolPanel(parent);
            
            obj.FeatureType = type;
            obj.ResetCurrentFeatureSource();
            obj.SelfListener = addlistener(obj, 'PropertyChanged', @obj.OnPropertyChanged);
        end
        
        function mgr = GetManager(obj)
            siman.Debug.ReportProblem(['GetManager was not overloaded in base class FeatureGraphPanel: ' obj.Name]);
            mgr = [];
        end
        
        function InitDefaults(obj)
            if isempty(obj.Name)
                obj.Name = 'Unknown feature graph panel';
            end
            if isempty(obj.Size)
                obj.Size = [260 280];
            end
            if isempty(obj.DockedLocation)
                obj.DockedLocation = 'south';
            end
            if isempty(obj.Stretchable)
                obj.Stretchable = true;
            end
        end
        
        function InitPanel(obj)
            InitPanel@siman.ToolPanel(obj);
        end
        
        function OnPropertyChanged(obj, src, evnt)
            switch evnt.PropertyName
                case 'ViewAll'
                    obj.QueueRedraw();
            end
        end
        
        function OnAttachedPlotChanged(obj, type)
            if ~strcmp(type, 'definition')
                obj.ResetCurrentFeatureSource();
            end
        end
        
        function ResetCurrentFeatureSource(obj)
            if isempty(obj.CurrentAttachedPlot)
                obj.SetFeatureSource([]);
                return;
            end
            source = obj.CurrentAttachedPlot.RawDataSource;
            obj.SetFeatureSource(source);
        end
        
        function SetFeatureSource(obj, source)
            if isempty(source) && isempty(obj.CurrentFeatureSource)
                return;
            end
            if length(source) ~= length(obj.CurrentFeatureSource) || source ~= obj.CurrentFeatureSource
                if isempty(source) || isempty(obj.CurrentFeatureSource)
                    obj.QueueLayout();
                end
                if ~isempty(obj.FeatureSourceListener)
                    delete(obj.FeatureSourceListener);
                    obj.FeatureSourceListener = [];
                end
                obj.CurrentFeatureSource = source;
                if ~isempty(source)
                    obj.FeatureSourceListener = addlistener(source, 'FeaturesChange', @obj.OnFeatureSourceChanged);
                    obj.FeatureSourceListener(2) = addlistener(source, 'FeatureChange', @obj.OnFeatureSourceChanged);
                end
                obj.SetPanelDataSource(obj.CurrentFeatureSource);
            end
        end
        
        function OnFeatureSourceChanged(obj, src, evt)
            obj.QueueRedraw();
        end
        
        function list = GetFeatureList(obj)
            source = obj.CurrentFeatureSource;
            if isempty(source)
                list = siman.List;
            else
                list = source.GetFeatureType(obj.FeatureType);
            end            
        end
        function list = GetSelectedFeatureList(obj)
            source = obj.CurrentFeatureSource;
            if isempty(source)
                list = siman.List;
            else
                list = source.GetSelectedFeatureType(obj.FeatureType);
            end            
        end
        
        function Redraw(obj)
            obj.RefreshControls();
            obj.UpdateGraph();
        end
        
        function ResetLayout(obj)
            obj.MakeControls();
        end
                
        % Handle enabling of controls tied to a local property
        function enabling = GetEnabling(obj, id, prop, context)
            enabling = true;
        end
        
        function delete(obj)
            delete(obj.FeatureSourceListener);
            obj.FeatureSourceListener = [];
        end
    end
end


