function handled = OnKeyPress(obj, event)
% OnKeyPress: Handle key presses

ctrlDown = ~isempty(find(strcmp(event.Modifier, 'control'), 1));
shiftDown = ~isempty(find(strcmp(event.Modifier, 'shift'), 1));
handled = true;
mgr = siman.ImageManager.Instance;
switch event.Key
    case 'leftarrow'
        if shiftDown
            obj.ChangeFrame(-10);
        else
            obj.ChangeFrame(-1);
        end
    case 'rightarrow'
        if shiftDown
            obj.ChangeFrame(10);
        else
            obj.ChangeFrame(1);
        end
    case 'home'
        obj.ChangeFrame(-Inf);
    case 'end'
        obj.ChangeFrame(Inf);
    otherwise
        handled = false;
end
mgr.ApplyChanges();
drawnow;