classdef ROIGraphPanel < siman.ToolPanel
    % ImagePropPanel
    properties (Transient)
        GraphAxesID
        ThumbnailAxesID
    end
    properties
        ROIType;
    end
    properties (SetObservable, GetObservable)
        ViewAll = true;
    end
    properties (Dependent)
        ROIList
        SelectedROIList
    end
    properties (Transient)
        ROISourceListener
        CurrentROISource
    end
    
    methods % Properties
        function list = get.ROIList(obj)
            list = obj.GetROIList();
        end
        
        function list = get.SelectedROIList(obj)
            list = obj.GetSelectedROIList();
        end
    end
    
    methods
        % Constructor
        function obj = ROIGraphPanel(parent)
            obj@siman.ToolPanel(parent);
            
            obj.ResetCurrentROISource();
            obj.SelfListener = addlistener(obj, 'PropertyChanged', @obj.OnPropertyChanged);
        end
        
        function mgr = GetManager(obj)
            siman.Debug.ReportProblem(['GetManager was not overloaded in base class ROIGraphPanel: ' obj.Name]);
            mgr = [];
        end
        
        function InitDefaults(obj)
            obj.Name = 'ROI Statistics/Graphs';
            obj.Size = [260 280];
            obj.DockedLocation = 'south';
            obj.Stretchable = true;
        end
        
        function InitPanel(obj)
            InitPanel@siman.ToolPanel(obj);
        end
        
        function OnPropertyChanged(obj, src, evnt)
            switch evnt.PropertyName
                case 'ViewAll'
                    obj.QueueRedraw();
            end
        end
        
        function OnAttachedPlotChanged(obj, type)
            if ~strcmp(type, 'definition')
                obj.ResetCurrentROISource();
            else
                obj.QueueRedraw();
            end
        end
        
        function ResetCurrentROISource(obj)
            if isempty(obj.CurrentAttachedPlot)
                obj.SetROISource([]);
                return;
            end
            %source = obj.CurrentAttachedPlot.RawDataSource;
            obj.SetROISource(obj.CurrentAttachedPlot);
        end
        
        function SetROISource(obj, source)
            if isempty(source) && isempty(obj.CurrentROISource)
                return;
            end
            if length(source) ~= length(obj.CurrentROISource) || source ~= obj.CurrentROISource
                if isempty(source) || isempty(obj.CurrentROISource)
                    obj.QueueLayout();
                end
                if ~isempty(obj.ROISourceListener)
                    delete(obj.ROISourceListener);
                    obj.ROISourceListener = [];
                end
                obj.CurrentROISource = source;
                if ~isempty(source)
                    obj.ROISourceListener = addlistener(source, 'ROIListChange', @obj.OnROIListChanged);
                    obj.ROISourceListener(2) = addlistener(source, 'ROIItemChange', @obj.OnROIItemChanged);
                end
                obj.SetPanelDataSource(obj.CurrentROISource);
            end
        end
        
        function OnROIListChanged(obj, src, evt)
            obj.QueueLayout();
        end
        
        function OnROIItemChanged(obj, src, evt)
            obj.QueueRedraw();
        end
        
        function list = GetROIList(obj)
            source = obj.CurrentROISource;
            if isempty(source)
                list = siman.List;
            else
                list = source.ROIList;
            end            
        end
        function list = GetSelectedROIList(obj)
            source = obj.CurrentROISource;
            if isempty(source)
                list = siman.List;
            else
                list = source.GetSelectedROIType(obj.ROIType);
            end            
        end
        
        function Redraw(obj)
            obj.RefreshControls();
            obj.UpdateGraph();
        end
        
        function ResetLayout(obj)
            obj.MakeControls();
        end
                
        % Handle enabling of controls tied to a local property
        function enabling = GetEnabling(obj, id, prop, context)
            enabling = true;
        end
        
        function delete(obj)
            delete(obj.ROISourceListener);
            obj.ROISourceListener = [];
        end
    end
end


