function UpdateGraph(obj)

axesID = obj.GraphAxesID;
if isempty(axesID)
    return
end
thumbnailAxesID = obj.ThumbnailAxesID;
list = obj.GetROIList();
count = list.Count;
cla(axesID);
cla(thumbnailAxesID);
if count == 0
    return;
end
thumbnail = [];
viewAll = obj.ViewAll;
drawnCount = 0;
for i = 1:count
    roi = list.ElementAt(i);
    isSelected = roi.IsSelected;
    %timeConversion = method.UnitConversion_Time;
    trace = roi.GetZTrace();
    if ~isempty(trace) && (viewAll || isSelected)
        drawnCount = drawnCount + 1;
        if isSelected && viewAll
            lineWidth = 3;
            color = [1 0 0];
        else
            lineWidth = 1;
            color = [0 0 0];
        end
        if isSelected || ~viewAll
            thumbnail = roi.Thumbnail;
        end
            
        xData = 1:length(trace);
        h = line('Parent', axesID, 'XData', xData, 'YData', trace, 'Color', color, 'LineWidth', lineWidth);
        
    end
end
if drawnCount > 0
    set(axesID, 'XLim', [xData(1) xData(end)]);
end

if isempty(thumbnail)
    return;
end

imagesc('CData', thumbnail, 'Parent', thumbnailAxesID);
set(thumbnailAxesID, 'DataAspectRatio', [1 1 1]);