classdef SparkletSite < siman.Feature
    % Must be a subclass of handle
    properties
        Width;
        PeakAmplitude;
        PeakXIndex;
        PeakYIndex;
        PeakZIndex;
        FrameCount;
        Area;
       
        Sparklets;
        SparkletCount;
        
        LowerXBound;
        UpperXBound;
        LowerYBound;
        UpperYBound;
        Waveform;
        Thumbnail;
        RegionXIndexes;
        RegionYIndexes;
        RegionZIndexes;
        
        Outlines;
        
        Baseline;
        BaselineRangeWidth;
    end
    
    methods (Static)
        function list = GetExportPropList()
            list = {'PeakAmplitude', 'PeakXIndex', 'PeakYIndex', 'PeakZIndex'};
        end
    end
    
    methods
        % Constructor
        function obj = SparkletSite()
            obj.Type = 'sparklet site';
        end
        
        function h = Draw(obj, ax, plot)
            for i = 1:length(obj.Outlines)
                outline = obj.Outlines{i};
                y = outline(:,1);
                x = outline(:,2);
                [x, y] = plot.ConvertPointsToPlot(x, y);
                if obj.IsSelected
                    lineWidth = 2;
                    color = [1 .7 0];
                else
                    lineWidth = 1;
                    color = [1 .4 0];
                end
                z = ones(numel(x),1) * 2;
                h = line(x, y, z, 'Parent', ax, 'Color', color, 'LineWidth', lineWidth);
            end
        end
        
        function h = DrawOnThumbnail(obj, ax)
            outline = obj.Outlines{1};
            y = outline(:,1);
            x = outline(:,2);
            z = ones(numel(x),1) * 2;
            lineWidth = 2;
            color = [.5 1 1];
            h = line(x, y, z, 'Parent', ax, 'Color', color, 'LineWidth', lineWidth);
        end
        
        function [x, y] = GetGraphData(obj)
            y = obj.Waveform;
            x = 1:length(y);
        end
        
        function str = GetListString(obj)
            str = [obj.Name ' (x=' num2str(obj.PeakXIndex) ', y=' num2str(obj.PeakYIndex)];
            str = [str ', ' num2str(obj.PeakAmplitude, '%10.2f') ') '];
            list = obj.Sparklets;
            str = [str num2str(list.ElementAt(1).Index)];
            for i = 2:min(list.Count, 3)
                str = [str ', ' num2str(list.ElementAt(i).Index)];
            end
            if list.Count > 3
                str = [str ', ...'];
            end
        end
        
        
        function data = GetExportData(obj)
            data = obj.Waveform;
        end
        
        function hit = HitTest(obj, area, ~) % obj, area, plot
            x = obj.RegionXIndexes;
            y = obj.RegionYIndexes;
            point1 = floor(area(1, [1 2]));
            point2 = ceil(area(2, [1 2]));
            hit = any(point1(2) <= y & point2(2) >= y & point1(1) <= x & point2(1) >= x);
        end
        
        function tf = IsInView(obj, area)
            z = area(1, 3);
            if ~ismember(z, obj.RegionZIndexes);
                tf = false;
                return
            end
            tf = true; % skipping x-y dimension for now
        end
        
        function point = CenteredPoint(obj)
            point = [obj.PeakXIndex, obj.PeakYIndex, obj.PeakZIndex];
        end
        
        function result = GetSparkletFrames(obj)
            list = obj.Sparklets;
            result = [];
            if isempty(list) || list.Count == 0
                return
            end
            for i = list.Count:-1:1 % to prevent most array growth
                sparklet = list.ElementAt(i);
                result(sparklet.LowerZBound:sparklet.UpperZBound) = 1;
            end
            result = find(result);
        end
    end
    
end







