classdef SparkletSiteManager < siman.FeatureManager
    % SparkletSiteManager.
    properties (Constant)
        Instance = siman.SparkletSiteManager; % Singleton object
        
        CommandPrefix = 'SparkletSite.';
        FeatureType = 'sparklet site';
    end
    
    methods (Access = private)
        % Constructor
        function obj = SparkletSiteManager()
            obj@siman.FeatureManager();
            
            % For development case where file was edited and the instance was deleted
            mgr = siman.ImageManager.GetManager();
            if isempty(mgr)
                return
            end
            
            obj.SourceArchivingProperty = 'LastSparkletSiteDetectionMethod';
            if isempty(obj.FeatureDetectionMethod)
                obj.FeatureDetectionMethod = siman.SparkletSitesMethod;
            end
        end
        
    end
    
    methods
        function DetectFeatures(obj, target)
            % override standard detection function to make sure there are sparklets to put in sites
            list = target.GetFeatureType('sparklet');
            if list.Count == 0
                sparkletMgr = siman.SparkletManager.GetManager();
                sparkletMgr.DetectFeatures(target);
            end
            DetectFeatures@siman.FeatureManager(obj, target);
        end
        
    end
    
    methods (Static = true)
        function mgr = GetManager()
            mgr = siman.SparkletSiteManager.Instance;
        end
    end
end





