classdef (ConstructOnLoad) SparksMethod < siman.FeatureDetectionMethod
    % SparksMethod.
    properties (Constant)
        ConnectivityTypeOptions = {'4', '8', '6', '18', '26'};
    end
    properties (GetObservable, SetObservable) % Registered properties
        ConnectivityType = '4';
        MinSize = 0;
        MaxSize = Inf;
        ThumbnailStartOffset = -10;
        ThumbnailStopOffset = 100;
        ThumbnailWidth = 50;
        TraceWidth = 1;
    end
    
    methods
        % Constructor
        function obj = SparksMethod()
            obj@siman.FeatureDetectionMethod();
        end
        
        function InitMethod(obj)
            obj.FeatureType = 'spark';
            obj.DetectionDefName = 'spark detection';
            obj.UnitsDefName = 'spark units';

            obj.DetectionMethodOptions = {'detection image'};
        end
        
        function def = GetDefaultDetectionDefinition(obj)
            def = GetDefaultDetectionDefinition@siman.FeatureDetectionMethod(obj);
            op = def.AddOperation('subtract background');
            op = def.AddOperation('median filter');
            op = def.AddOperation('calculate baseline');
            op = def.AddOperation('threshold');
            op.ThresholdType = 'baseline st dev';
            op = def.AddOperation('morph');
            op.MorphType = 'erode';
            op.MorphKernel.Width = 5;
            op = def.AddOperation('morph');
            op.MorphType = 'dilate';
        end
        
        function def = GetDefaultUnitsDefinition(obj)
            def = GetDefaultUnitsDefinition@siman.FeatureDetectionMethod(obj);
            op = def.AddOperation('subtract background');
            op = def.AddOperation('median filter');
            op = def.AddOperation('calculate baseline');
            op = def.AddOperation('baseline normalization');
        end
                      
    end
end





