classdef TransientManager < siman.FeatureManager
    % TransientManager.
    properties (Constant)
        Instance = siman.TransientManager; % Singleton object
        
        CommandPrefix = 'Transient.';
        FeatureType = 'transient';
    end
    
    methods (Access = private)
        % Constructor
        function obj = TransientManager()
            obj@siman.FeatureManager();
            
            % For development case where file was edited and the instance was deleted
            mgr = siman.ImageManager.GetManager();
            if isempty(mgr)
                return
            end
            
            obj.SourceArchivingProperty = 'LastTransientDetectionMethod';
            if isempty(obj.FeatureDetectionMethod)
                obj.FeatureDetectionMethod = siman.TransientsMethod;
            end
        end
    end
        
    methods
        function OnPreDetection(obj, method, target)
            OnPreDetection@siman.FeatureManager(obj, method, target);
            target.ClearFeatureType('time profile');
        end
    end
    
    methods (Static = true)
        function mgr = GetManager()
            mgr = siman.TransientManager.Instance;
        end
    end
end





