<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- Edited by XMLSpy -->
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="/">
    <html>
      <head>
        <link rel="stylesheet" type="text/css">
          <xsl:attribute name="href">
            <xsl:value-of select="featurereport/@resourcespath"/>/<xsl:value-of select="featurereport/@cssfilename"/>
          </xsl:attribute>
        </link>
        <title>
          <xsl:value-of select="featurereport/@name"/> - <xsl:value-of select="featurereport/@type"/>s
        </title>
      </head>
      <body>
        <div class="title">
          <h1>SImAn Feature Detection Report</h1>
        </div>
          <span class="image">
            <img>
              <xsl:attribute name="src">
                <xsl:value-of select="featurereport/resources/mainthumbnail/@path"/>
              </xsl:attribute>
            </img>
          </span>
        <h2>
          Source image: <span class="filename">
            <xsl:value-of select="featurereport/@name"/>
          </span>
        </h2>
        <h2>
          Feature type: <xsl:value-of select="featurereport/@type"/>
        </h2>
        <h2>Sections</h2>
        <ul>
          <li>
            <a href="#summary">Feature Summary</a>
          </li>
          <li>
            <a href="#features">Feature Details</a>
          </li>
          <li>
            <a href="#method">Detection Method</a>
            <ul>
              <li>
                <a href="#detectiondef">Detection Definition</a>
              </li>
              <li>
                <a href="#unitsdef">Units Definition</a>
              </li>
            </ul>
          </li>
        </ul>
        <br></br>
        <hr></hr>
        <br></br>
        <xsl:apply-templates select="featurereport/summary"/>
        <br></br>
        <hr></hr>
        <br></br>
        <xsl:apply-templates select="featurereport/features"/>
        <br></br>
        <hr></hr>
        <br></br>
        <xsl:apply-templates select="featurereport/method"/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="summary">
    <a id="summary"></a>
    <h2 class="sectionheading">Summary</h2>
    <br></br>
    <span class="image">
      <img>
        <xsl:attribute name="src">
          <xsl:value-of select="summary_image/@path"/>
        </xsl:attribute>
      </img>
    </span>
    <h3>Biggest Features</h3>
    <table>
      <xsl:for-each select="/featurereport/features/featuretype/featurelist/feature">
        <xsl:sort select="@value" order="descending"/>
        <xsl:if test="position()&lt;=10">
        <tr>
          <td>
            <a>
              <xsl:attribute name="href">
                #<xsl:value-of select="@name"/>
              </xsl:attribute>
              <xsl:value-of select="@name"/>            
            </a>
          </td>
          <td>
            <xsl:value-of select="@value"/>
          </td>
        </tr>
        </xsl:if>
      </xsl:for-each>
    </table>
  </xsl:template>

  <xsl:template match="method">
    <a id="method"></a>
    <h2 class="sectionheading">Detection Method Parameters</h2>
    <br></br>
    <br></br>
    <xsl:apply-templates select="detectiondef"/>
    <br></br>
    <xsl:apply-templates select="unitsdef"/>
  </xsl:template>

  <xsl:template match="detectiondef">
    <a id="detectiondef"></a>
    <h3 class="processingdeftitle">Processing Steps for Detection</h3>
    <br></br>
    <xsl:apply-templates select="celldefinition"/>
    <span class="processingdefsection">Operations</span>
    <br />
    <xsl:apply-templates select="operation"/>
  </xsl:template>

  <xsl:template match="unitsdef">
    <a id="unitsdef"></a>
    <h3 class="processingdeftitle">Processing Steps for Units</h3>
    <br></br>
    <xsl:apply-templates select="celldefinition"/>
    <span class="processingdefsection">Operations</span>
    <br />
    <xsl:apply-templates select="operation"/>
  </xsl:template>

  <xsl:template match="celldefinition">
    <span class="processingdefsection">Cell Definition</span>
    <br />
    <xsl:apply-templates select="cellmethodology"/>
    <xsl:apply-templates select="cellsummary"/>
  </xsl:template>

  <xsl:template match="cellmethodology">
    <span class="processingdefsubsection">Methodology:</span>
    <br />
    <xsl:apply-templates select="parameter"/>
  </xsl:template>

  <xsl:template match="cellsummary">
    <span class="processingdefsubsection">Cell Summary:</span>
    <br />
    <xsl:apply-templates select="parameter"/>
    <br />
  </xsl:template>

  <xsl:template match="parameter">
    <span class="param">
      <xsl:value-of select="@name"/> = <xsl:value-of select="@value"/>
    </span>
    <br />
  </xsl:template>

  <xsl:template match="operation">
    <span class="operation">
      <xsl:value-of select="attribute::type"/>
    </span>
    <br />
    <xsl:apply-templates select="parameter"/>
  </xsl:template>

  <xsl:template match="features">
    <a id="features"></a>
    <h2 class="sectionheading">Features Detected</h2>
    <br></br>
    <br></br>
    <xsl:apply-templates select="featuretype"/>
  </xsl:template>

  <xsl:template match="featuretype">
    <xsl:apply-templates select="featurelist"/>
  </xsl:template>

  <xsl:template match="featurelist">
    <xsl:apply-templates select="feature"/>
  </xsl:template>

  <xsl:template match="feature">
    <span class="image">
      <img>
        <xsl:attribute name="src">
          <xsl:value-of select="graph/@path"/>
        </xsl:attribute>
      </img>
    </span>
    <span class="image">
      <img>
        <xsl:attribute name="src">
          <xsl:value-of select="thumbnail/@path"/>
        </xsl:attribute>
      </img>
    </span>
    <span class="image">
      <img>
        <xsl:attribute name="src">
          <xsl:value-of select="location/@path"/>
        </xsl:attribute>
      </img>
    </span>
    <a>
      <xsl:attribute name="id">
        <xsl:value-of select="@name"/>
      </xsl:attribute>
    </a>
    <xsl:value-of select="@name"/>
    <ul>
      <xsl:apply-templates select="property"/>
    </ul>
    <br />
  </xsl:template>
  
  <xsl:template match="property">
    <li class="property"><xsl:value-of select="@name"/> = <xsl:value-of select="@value"/></li>
  </xsl:template>


</xsl:stylesheet>

