function trace = get_z_trace( input, center, nhood )
%get_z_trace: get a trace through a z-stack given a center point and neighborhood

dim = size(nhood);
[x, y] = xyindexes(find(nhood), dim);
xOffsets = x - round(dim(2)/2) + center(1);
yOffsets = y - round(dim(1)/2) + center(2);

dim = size3d(input);
traceLength = dim(3);
frameSize = dim(1) * dim(2);
indexes = (xOffsets-1) * dim(1) + yOffsets;

temp = reshape(input, [frameSize, traceLength]);
traces = temp(indexes, :);
if length(nhood) == 1
    trace = traces';
else
    trace = mean(traces)';
end