function CreateXML(obj, context, def_node)

docNode = context.DocNode;

def_node.setAttribute('format', obj.Orientation);
switch (obj.Orientation)
    case 'linescan'
        % Write detection method parameters
        methodNode = docNode.createElement('cellmethodology');
        def_node.appendChild(methodNode);
        methodNode.setAttribute('type', obj.Type);
        
        switch obj.Type
            case 'threshold'
                createParameterNode(docNode, methodNode, 'Threshold type', obj.ThresholdType);
                switch obj.ThresholdType
                    case 'percentile'
                        createParameterNode(docNode, methodNode, 'Threshold percentile', obj.Threshold_Percentile);
                end
                createParameterNode(docNode, methodNode, 'Threshold', obj.Threshold_Actual);
        end
        
        % Write result summary parameters
        summaryNode = docNode.createElement('cellsummary');
        def_node.appendChild(summaryNode);
        createParameterNode(docNode, summaryNode, 'Lower edge', obj.LowerEdge);
        createParameterNode(docNode, summaryNode, 'Upper edge', obj.UpperEdge);
        
    case '2-d'
        % Write detection method parameters
        methodNode = docNode.createElement('cellmethodology');
        def_node.appendChild(methodNode);
        methodNode.setAttribute('type', obj.Type);
        
        switch obj.Type
            case 'threshold'
                createParameterNode(docNode, methodNode, 'Threshold type', obj.ThresholdType);
                switch obj.ThresholdType
                    case 'percentile'
                        createParameterNode(docNode, methodNode, 'Threshold percentile', obj.Threshold_Percentile);
                end
                createParameterNode(docNode, methodNode, 'Threshold', obj.Threshold_Actual);
        end
        createParameterNode(docNode, methodNode, 'Connectivity', obj.ConnectivityType);
        createParameterNode(docNode, methodNode, 'Min region area', obj.MinSize);
        createParameterNode(docNode, methodNode, 'Max region area', obj.MaxSize);
        
        % Write result summary parameters
        summaryNode = docNode.createElement('cellsummary');
        def_node.appendChild(summaryNode);
        createParameterNode(docNode, summaryNode, 'Total area', length(find(obj.CellMask(:))));
        createParameterNode(docNode, summaryNode, 'Number of areas', length(obj.Outlines));
end


    
