classdef Contraction < siman.Feature
    % Must be a subclass of handle
    properties
        StartEdges;
        EndEdges;
        CellWidth;
    end
    
    methods
        % Constructor
        function obj = Contraction()
            obj.Type = 'contraction';
        end
        
        function h = Draw(obj, ax, plot)
            x = obj.StartEdges;
            y = 1:numel(x);
            [x, y] = plot.ConvertPointsToPlot(x, y);
            z = ones(numel(x), 1) * 2;
            h = line(x, y, z, 'Parent', ax, 'Color', [.5 1 .5], 'LineWidth', 2);
            x = obj.EndEdges;
            x = plot.ConverPointsToPlot(x, y);
            h = line(x, y, z, 'Parent', ax, 'Color', [.5 1 .5], 'LineWidth', 2);
        end
        
        function str = GetListString(obj)
            str = obj.Name;
        end
        
        function list = GetExportPropList(obj)
            list = {};
        end
        
        function data = GetExportData(obj)
            data = obj.CellWidth;
        end
        
        function hit = HitTest(obj, area, plot)
            hit = false;
        end
        
        function ans = IsInView(obj, area)
            ans = true;
        end
        
        function point = CenteredPoint(obj, point)
            point = [0, 0];
        end
    end
end







