function MakeControls(obj)

import siman.*;
parentPanel = obj.PanelID;
margin = siman.UIHelper.PANEL_MARGIN;
parentPos = get(parentPanel, 'Position');
top = parentPos(4)-margin-siman.UIHelper.PANEL_TOP_OFFSET;
source = obj.FeatureDetectionMethod;
manager = siman.ContractionManager.Instance;


controlParams.ParentPanel = parentPanel;
controlParams.DataObject = source;
controlParams.Controller = source;

children = get(parentPanel, 'Children');
delete(children);

location = [margin top];

% Show notice of no definition
if isempty(source)
    siman.UIHelper.MakeLabel(['No ' obj.FeatureType ' definition'], ...
                    location, controlParams);
    return
end

% Add main controls that won't change

controlParams.Width = 120;
location = siman.UIHelper.MakeLabeledPopup('DetectionMethod', 'Method:', ...
    location, controlParams);

location(2) = location(2) - 10;

switch source.DetectionMethod
    case 'mean percent'
        controlParams.Width = 60;
        location = siman.UIHelper.MakeLabeledTextbox('CrossSectionMedianFilterWidth', 'Median filter:', ...
            location, controlParams);

        controlParams.Width = 60;
        location = siman.UIHelper.MakeLabeledTextbox('ThresholdPercent', 'Threshold percent:', ...
            location, controlParams);
        
        controlParams.Width = 60;
        location = siman.UIHelper.MakeLabeledTextbox('BinaryFilterWidth', 'Binary filter width:', ...
            location, controlParams);
        
        controlParams.Width = 60;
        location = siman.UIHelper.MakeLabeledTextbox('EdgeMedianFilterWidth', 'Edge filter width:', ...
            location, controlParams);
        
        location(2) = location(2) - 20;
        
        controlParams.Width = 60;
        location = siman.UIHelper.MakeLabeledTextbox('UnitConversion_Width', 'Conversion factor:', ...
            location, controlParams);
end
        
prefix = manager.CommandPrefix;
controlParams.CommandName = [prefix 'Detect'];
controlParams.LocationType = 'lower right';
controlParams.ButtonWidth = 50;
controlParams.Context = obj;
location = [parentPos(3)-margin margin];
location = siman.UIHelper.MakeButton(location, 'Detect', controlParams);
