classdef ContractionManager < siman.FeatureManager
    % ContractionManager.
    properties (Constant)
        Instance = siman.ContractionManager; % Singleton object
        
        CommandPrefix = 'Contraction.';
        FeatureType = 'contraction';
    end
    
    methods (Access = private)
        % Constructor
        function obj = ContractionManager()
            obj@siman.FeatureManager();
            
            % For development case where file was edited and the instance was deleted
            mgr = siman.ImageManager.GetManager();
            if isempty(mgr)
                return
            end
            
            obj.SourceArchivingProperty = 'LastContractionDetectionMethod';
            if isempty(obj.FeatureDetectionMethod)
                obj.FeatureDetectionMethod = siman.ContractionMethod;
            end
        end
    end
    
    methods (Static = true)
        function mgr = GetManager()
            mgr = siman.ContractionManager.Instance;
        end
    end
end





