classdef (ConstructOnLoad) ContractionMethod < siman.FeatureDetectionMethod
    % ContractionDefinition.
    properties (GetObservable, SetObservable) % Registered properties
        UnitConversion_Width = 1;
        CrossSectionMedianFilterWidth = 9;
        ThresholdPercent = 100;
        BinaryFilterWidth = 5;
        EdgeMedianFilterWidth = 5;
    end
    
    methods
        % Constructor
        function obj = ContractionMethod()
            obj@siman.FeatureDetectionMethod();
            
            obj.InitDefaultDefs();
        end     
        
        function InitMethod(obj)
            obj.FeatureType = 'contraction';
            obj.DetectionDefName = 'contraction detection';

            obj.DetectionMethodOptions = {'mean percent'};
        end
        
        function InitDefaultDefs(obj)
            if isempty(obj.DetectionDefinition)
                def = siman.ProcessingDefinition;
                def.Name = obj.DetectionDefName;
                def.IsSystemDefinition = true;
                %op = def.AddOperation();
                %op.Type = 'subtract background';
                obj.DetectionDefinition = def;
            end
        end
    end
end





