function [list, message] = Detect(obj, target)

method = obj.DetectionMethod;
switch method
    case 'mean percent'
        [list, message] = DetectMeanPercent(obj, target);
    otherwise
        list = siman.List;
        message = ['Unknown detection method: ' type];
end
end

function [list, message] = DetectMeanPercent(obj, target)
    
    list = siman.List;
    message = '';

    detectionDef = obj.DetectionDefinition;
    data = double(detectionDef.ProcessSource(target));
    dim = size(data);
    width = dim(2);
    height = dim(1);
    
    conversionFactor = obj.UnitConversion_Width;
    filterWidth = obj.CrossSectionMedianFilterWidth;
    thresholdPercent = obj.ThresholdPercent;
    if thresholdPercent > 1
        thresholdPercent = thresholdPercent/100;
    end
    binaryFilterWidth = obj.BinaryFilterWidth;
    edgeFilterWidth = obj.EdgeMedianFilterWidth;

    startEdges = zeros(height, 1);
    endEdges = zeros(height, 1);
    
    for i = 1:height
        trace = data(i, :);
        trace = medfilt1(trace, filterWidth);
        cellThreshold = thresholdPercent * mean(trace);
        isCell = trace > cellThreshold;
        isCell = medfilt1(double(isCell), binaryFilterWidth);
        
        cellIndexes = find(isCell);
        startEdges(i) = min(cellIndexes);
        endEdges(i) = max(cellIndexes);
    end
    
    startEdges = medfilt1(startEdges, edgeFilterWidth);
    endEdges = medfilt1(endEdges, edgeFilterWidth);
    
    feature = siman.Contraction();
    feature.Name = ['CellWidth - ' target.Name];
    feature.Index = i;
    feature.StartEdges = startEdges;
    feature.EndEdges = endEdges;
    feature.CellWidth = (endEdges-startEdges+1) * conversionFactor;
    target.AddFeature(feature);
    list.Add(feature);
end





