function InitMenu(obj)
%InitMenu Initialize the menu of the display figure
%   Detailed explanation goes here

fig = obj.FigureID;
controlParams.Context = obj;
controlParams.ParentMenu = fig;

fileMenu = siman.UIHelper.MakeParentMenu('File', 'FileMenu', false, controlParams);
editMenu = siman.UIHelper.MakeParentMenu('Edit', 'EditMenu', false, controlParams);
viewMenu = siman.UIHelper.MakeParentMenu('View', 'ViewMenu', false, controlParams);
toolsMenu = siman.UIHelper.MakeParentMenu('Tools', 'ToolsMenu', false, controlParams);
windowMenu = siman.UIHelper.MakeParentMenu('Window', 'WindowMenu', false, controlParams);

controlParams.ParentMenu = fileMenu;
siman.UIHelper.MakeMenuItem('Open image files...', 'File.OpenImageFiles', false, controlParams);
siman.UIHelper.MakeMenuItem('Open image directory...', 'File.OpenImageDirectory', false, controlParams);
siman.UIHelper.MakeMenuItem('Save full image as...', 'File.SaveFullImageAs', true, controlParams);
siman.UIHelper.MakeMenuItem('Save image stack as...', 'File.SaveImageStackAs', false, controlParams);
siman.UIHelper.MakeMenuItem('Save visible image as...', 'File.SaveVisibleImageAs', false, controlParams);
siman.UIHelper.MakeMenuItem('Save data as...', 'File.SaveDataAs', true, controlParams);

controlParams.ParentMenu = editMenu;
siman.UIHelper.MakeMenuItem('Copy full image', 'Edit.CopyFullImage', false, controlParams);
siman.UIHelper.MakeMenuItem('Copy data', 'Edit.CopyFullImage', false, controlParams);

controlParams.ParentMenu = viewMenu;
siman.UIHelper.MakeMenuItem('Zoom in', 'View.ZoomIn', false, controlParams, '=');
siman.UIHelper.MakeMenuItem('Zoom out', 'View.ZoomOut', false, controlParams, '-');
siman.UIHelper.MakeMenuItem('Show colorbar', 'View.ShowColorbar', true, controlParams, 'B');
siman.UIHelper.MakeMenuItem('Lock display', 'View.LockPlot', true, controlParams, 'L');

controlParams.ParentMenu = toolsMenu;
roiMenu = siman.UIHelper.MakeParentMenu('Add ROI', 'Tools.ROI.AddROI', false, controlParams);
controlParams.ParentMenu = roiMenu;
list = siman.ROI.TypeOptions;
for i = 1:length(list)
    siman.UIHelper.MakeMenuItem(list{i}, 'Tools.ROI.AddROIType', false, controlParams);
end
controlParams.ParentMenu = toolsMenu;
siman.UIHelper.MakeMenuItem('Delete all ROIs', 'Tools.ROI.ClearAllROIs', false, controlParams);
siman.UIHelper.MakeMenuItem('Make movie...', 'Tools.MakeMovie', true, controlParams);

controlParams.ParentMenu = windowMenu;
siman.UIHelper.MakeMenuItem('Inventory', 'Window.ShowInventory', false, controlParams);
siman.UIHelper.MakeMenuItem('Image/Color properties', 'Window.ShowImageProp', true, controlParams);
siman.UIHelper.MakeMenuItem('Processing definition', 'Window.ShowProcessingDef', true, controlParams);
siman.UIHelper.MakeMenuItem('Cell definition', 'Window.ShowCellDef', false, controlParams);
siman.UIHelper.MakeMenuItem('Regions of Interest', 'Window.ShowROIGraph', true, controlParams);
siman.UIHelper.MakeMenuItem('Transient detection', 'Window.ShowTransientDetection', true, controlParams);
siman.UIHelper.MakeMenuItem('Transient list', 'Window.ShowTransientList', false, controlParams);
siman.UIHelper.MakeMenuItem('Transient graph', 'Window.ShowTransientGraph', false, controlParams);
siman.UIHelper.MakeMenuItem('Spark detection', 'Window.ShowSparkDetection', true, controlParams);
siman.UIHelper.MakeMenuItem('Spark list', 'Window.ShowSparkList', false, controlParams);
siman.UIHelper.MakeMenuItem('Spark graph', 'Window.ShowSparkGraph', false, controlParams);
siman.UIHelper.MakeMenuItem('Sparklet detection', 'Window.ShowSparkletDetection', true, controlParams);
siman.UIHelper.MakeMenuItem('Sparklet list', 'Window.ShowSparkletList', false, controlParams);
siman.UIHelper.MakeMenuItem('Sparklet graph', 'Window.ShowSparkletGraph', false, controlParams);
siman.UIHelper.MakeMenuItem('Sparklet site detection', 'Window.ShowSparkletSiteDetection', false, controlParams);
siman.UIHelper.MakeMenuItem('Sparklet site list', 'Window.ShowSparkletSiteList', false, controlParams);
siman.UIHelper.MakeMenuItem('Sparklet site graph', 'Window.ShowSparkletSiteGraph', false, controlParams);
siman.UIHelper.MakeMenuItem('Contraction detection', 'Window.ShowContractionDetection', true, controlParams);
siman.UIHelper.MakeMenuItem('Contraction graph', 'Window.ShowContractionGraph', false, controlParams);
siman.UIHelper.MakeMenuItem('Close all', 'Window.CloseAllToolPanels', true, controlParams);

