function ResetLayout(obj)

import siman.*;

figID = obj.FigureID;
units = get(figID, 'Units');
set(figID, 'Units', 'pixels');
fpos = get(figID, 'Position');

panels = obj.Panels.ToCellArray();
panelCount = numel(panels);
locations = cell(panelCount, 1);
for i = 1:panelCount
    panel = panels{i};
    locations{i} = panel.DockedLocation;
end

freeSpace = [0, 0, fpos(3), fpos(4)];
panelMarginWidth = 4;
panelMargins = [panelMarginWidth panelMarginWidth -2*panelMarginWidth -2*panelMarginWidth];

% Calculate size of east panel
indexes = find(strcmp('east', locations));
% First determine allocation of space to various panel types
freePanelHeight = freeSpace(4);
stretchableCount = 0;
maxPanelWidth = 0;
for i = 1:length(indexes)
    idx = indexes(i);
    panel = panels{idx};
    sz = panel.Size;
    maxPanelWidth = max(maxPanelWidth, sz(1));
    if panel.Stretchable
        stretchableCount = stretchableCount + 1;
    else
        freePanelHeight = max(0, freePanelHeight - sz(2));
    end    
end
freeSpace(3) = freeSpace(3) - maxPanelWidth;
panelLeftEdge = freeSpace(3) - 1;
topEdge = freeSpace(4);
% Now set actual panel sizes
for i = 1:length(indexes)
    panel = panels{indexes(i)};
    sz = panel.Size;
    if ~panel.Stretchable
        panelHeight = sz(2);
    else
        panelHeight = freePanelHeight/stretchableCount;
    end
    panelPos = [panelLeftEdge, topEdge - panelHeight - 1, maxPanelWidth, panelHeight] + panelMargins;
    panelPos(3) = max(panelPos(3), 1);
    panelPos(4) = max(panelPos(4), 1);
    topEdge = topEdge - panelHeight;
    panel.SetBounds(panelPos);
end


% Calculate size of south panel
indexes = find(strcmp('south', locations));
% First determine allocation of space to various panel types
panelWidth = freeSpace(3);
totalPanelHeight = 0;
for i = 1:length(indexes)
    panel = panels{indexes(i)};
    sz = panel.Size;
    totalPanelHeight = totalPanelHeight + sz(2);
end
freeSpace(4) = freeSpace(4) - totalPanelHeight;
panelLeftEdge = freeSpace(1);
% Now set actual panel sizes
for i = 1:length(indexes)
    panel = panels{indexes(i)};
    sz = panel.Size;
    panelPos = [panelLeftEdge, freeSpace(2), panelWidth, sz(2)] + panelMargins;
    panelPos(3) = max(panelPos(3), 1);
    panelPos(4) = max(panelPos(4), 1);
    freeSpace(2) = freeSpace(2) + sz(2);
    panel.SetBounds(panelPos);
end



% Old panel code that did not allow multiple panels at each location
% for i = 1:panelCount
%     panel = panels.ElementAt(i);
%     dockLoc = panel.DockedLocation;
%     panelPos = [];
%     switch dockLoc
%         case 'east'
%             sz = panel.Size;
%             panelPos = [freeSpace(3) - sz(1), freeSpace(2), sz(1), freeSpace(4)] + panelMargins;
%             freeSpace(3) = freeSpace(3) - sz(1);
%         case 'south'
%             sz = panel.Size;
%             panelPos = [0, 0, freeSpace(3), sz(2)] + panelMargins;
%             freeSpace(4) = freeSpace(4) - sz(2);
%             freeSpace(2) = freeSpace(2) + sz(2);
%     end
%     if ~isempty(panelPos) 
%         panel.SetBounds(panelPos);
%     end
% end

if freeSpace(3) < 1
    freeSpace(3) = 1;
end
if freeSpace(4) < 1
    freeSpace(4) = 1;
end

obj.PlotPanel.SetBounds(freeSpace);
set(figID, 'Units', units);

