function GenerateFeatureReport(obj, context)

docNode = context.DocNode;
method = context.Method;

root = docNode.getDocumentElement();
root.setAttribute('type', context.FeatureType);
root.setAttribute('detectiondate', method.DetectionDate);
root.setAttribute('version', '1.0');

% Add nodes describing the method
methodNode = docNode.createElement('method');
methodNode.setAttribute('type', method.FeatureType);
root.appendChild(methodNode);
method.CreateXML(context, methodNode);

% Add a node to store resources
resourcesNode = docNode.createElement('resources');
methodNode.setAttribute('id', 'resources');
root.appendChild(resourcesNode);

% Add any extra stuff from this particular feature type
context.FeatureManager.CreateXMLCustomParts(context);

% Now on to actual features
featuresNode = docNode.createElement('features');
root.appendChild(featuresNode);
obj.CreateXML(context, featuresNode);













