classdef FeatureDefPanel < siman.ToolPanel
    % ImagePropPanel
    properties
        FeatureDetectionMethod
    end
    properties (Transient)
        FeatureMethodListener
        CurrentTarget
    end
    properties (Dependent)
        TargetDataSources  % Detect command interface
    end
    
    methods % Properties
        
        function list = get.TargetDataSources(obj)
            list = siman.List;
            if ~isempty(obj.CurrentTarget)
                list.Add(obj.CurrentTarget)
            end
        end
    end
    
    methods
        % Constructor
        function obj = FeatureDefPanel(parent)
            obj@siman.ToolPanel(parent);
            obj.ResetCurrentFeatureMethod();
        end
        
        function InitDefaults(obj)
            if isempty(obj.Name)
                obj.Name = 'Unknown feature detection panel';
            end
            if isempty(obj.Size)
                obj.Size = [200 200];
            end
            if isempty(obj.DockedLocation)
                obj.DockedLocation = 'east';
            end
        end
        
        function InitPanel(obj)
            InitPanel@siman.ToolPanel(obj);
        end
        
        function OnAttachedPlotChanged(obj, type)
            if ~strcmp(type, 'definition')
                obj.ResetCurrentFeatureMethod();
                obj.ResetCurrentTarget();
            end
        end
        
        function mgr = GetManager(obj)
            siman.Debug.ReportProblem(['GetManager was not overloaded in base class FeatureDefPanel: ' obj.Name]);
            mgr = [];
        end
        
        function ResetCurrentFeatureMethod(obj)
            manager = obj.GetManager();
            method = manager.FeatureDetectionMethod;
            obj.SetFeatureDetectionMethod(method);
        end
        
        function SetFeatureDetectionMethod(obj, method)
            if isempty(method) && isempty(obj.FeatureDetectionMethod)
                return;
            end
            if length(method) ~= length(obj.FeatureDetectionMethod) || method ~= obj.FeatureDetectionMethod
                if ~isempty(obj.FeatureMethodListener)
                    delete(obj.FeatureMethodListener);
                    obj.FeatureMethodListener = [];
                end
                obj.FeatureDetectionMethod = method;
                if ~isempty(method)
                    obj.FeatureMethodListener = addlistener(method, 'MethodChange', @obj.OnFeatureMethodChanged);
                    obj.FeatureMethodListener(2) = addlistener(method, 'MethodLayoutChange', @obj.OnFeatureMethodLayoutChanged);
                    obj.FeatureMethodListener(3) = addlistener(method, 'MethodRan', @obj.OnFeatureMethodRan);
                end
                obj.QueueLayout();
                obj.SetPanelDataSource(method);
            end
        end
        
        function OnFeatureMethodRan(obj, src, evt)
            obj.QueueRedraw();
        end
        
        function OnFeatureMethodChanged(obj, src, evt)
            obj.QueueRedraw();
        end
        
        function OnFeatureMethodLayoutChanged(obj, src, evt)
            obj.QueueLayout();
        end
        
        function ResetCurrentTarget(obj)
            target = [];
            plot = obj.CurrentAttachedPlot;
            if ~isempty(plot)
                target = plot.RawDataSource;
            end
            obj.SetFeatureDetectionTarget(target);
        end
        
        function SetFeatureDetectionTarget(obj, target)
            if isempty(target) && isempty(obj.CurrentTarget)
                return;
            end
            if length(target) ~= length(obj.CurrentTarget) || target ~= obj.CurrentTarget
                obj.CurrentTarget = target;
                obj.QueueRedraw();
            end
        end
        
        function Redraw(obj)
            obj.RefreshControls();
        end
        
        function ResetLayout(obj)
            obj.MakeControls();
        end
                
        function delete(obj)
            delete(obj.FeatureMethodListener);
            obj.FeatureMethodListener = [];
        end
    end
end


