function varargout = FileIO(obj, type)

switch type
    case 'open image files'
      if nargout > 0
         [varargout{1:nargout}] = OpenImageFiles(obj);
      else
         OpenImageFiles(obj);
      end
    case 'open image directory'
        [varargout{:}] = OpenImageDirectory(obj);
end
end

function image_objs = OpenImageFiles(obj)
    image_objs = [];
    default = obj.LastImagePath;
    [filenames, path] = uigetfile({'*.tif;*.tiff;*.pic;*.jpg;*.jpeg', 'Image files'}, ...
        'Choose Image Files', default, 'MultiSelect', 'on');
    if isequal(filenames, 0)
        return
    elseif ischar(filenames)
        filenames = {filenames};
    end
    for i = 1:length(filenames)
        filenames{i} = fullfile(path, filenames{i});
    end
    disp('Showing file names returned from OS.')
    for i = 1:length(filenames)
        disp(filenames{i});
    end
    obj.LastImagePath = filenames{1};
    image_objs = obj.CreateImageFileObjs(filenames);
    
end