function DrawCell(obj)

graphics = obj.CellGraphics;
if ~isempty(graphics)
    delete(graphics(ishandle(graphics) & graphics > 0));
    obj.CellGraphics = [];
end

source = obj.RawDataSource;
if isempty(source) || ~source.IsValid
    return
end

if ~obj.CellVisible
    return
end

cellDef = source.CellDefinition;
if isempty(cellDef) || cellDef.NoCellDefined
    return
end

if cellDef.NeedsUpdating
    cellDef.DetermineCellMask(source);
end

if ~cellDef.IsValid
    text(.5, .1, cellDef.ErrorMessage, 'Parent', obj.MessageAxesID, ...
        'HorizontalAlignment', 'center', 'FontSize', 12, 'Color', [1 0 0]);
    return
end

switch cellDef.Orientation
    case 'linescan'
        DrawLinescanCell(obj);
    case '2-d'
        Draw2dCell(obj);
end
end

function DrawLinescanCell(obj)
    source = obj.RawDataSource;
    cellDef = source.CellDefinition;
    
    axesid = obj.AxesID;
    color = obj.CellColor;
    alpha = .75;
    imSize = obj.ImageSize;
    edgeLimit = imSize(2);
    linescanLength = imSize(1);
    height = imSize(1);
    
    lowerEdge = cellDef.LowerEdge;
    upperEdge = cellDef.UpperEdge;
    if isinf(upperEdge)
        upperEdge = edgeLimit;
    end
    
    %type = obj.CellIndicatorType;
    type = 'outline';
    switch type
        case 'mask'
            xLower = [1 lowerEdge lowerEdge 1];
            xUpper = [upperEdge edgeLimit edgeLimit upperEdge];
            yLower = [1 1 linescanLength linescanLength];
            %yLower = lim([1 1 2 2]);
            yUpper = yLower;
            [xLower, yLower] = obj.ConvertPointsToPlot(xLower, yLower);
            [xUpper, yUpper] = obj.ConvertPointsToPlot(xUpper, yUpper);
            z = [1 1 1 1]*10;
            h = [];
            if lowerEdge > 1
                h = patch(xLower, yLower, z, 'Parent', axesid, 'FaceAlpha', alpha, 'FaceColor', color);
            end
            if upperEdge < edgeLimit
                h(end + 1) = patch(xUpper, yUpper, z, 'Parent', axesid, 'FaceAlpha', alpha, 'FaceColor', color);
            end
        case 'outline'
            xpoints1 = [lowerEdge lowerEdge];
            xpoints2 = [upperEdge upperEdge];
            ypoints1 = [1 height];
            ypoints2 = [1 height];
            [xpoints1, ypoints1] = obj.ConvertPointsToPlot(xpoints1, ypoints1);
            [xpoints2, ypoints2] = obj.ConvertPointsToPlot(xpoints2, ypoints2);
            h = line(xpoints1, ypoints1, [1 1], 'Parent', axesid, 'Color', color);
            h(2) = line(xpoints2, ypoints2, [1 1], 'Parent', axesid, 'Color', color);
    end
    obj.CellGraphics = h;
end

function Draw2dCell(obj)
    source = obj.RawDataSource;
    cellDef = source.CellDefinition;
    
    axesid = obj.AxesID;
    color = obj.CellColor;
    type = obj.CellIndicatorType;
    type = 'outline';
    switch type
        case 'mask'
        case 'outline'
            h = zeros(numel(cellDef.Outlines));
            for i = 1:length(cellDef.Outlines)
                outline = cellDef.Outlines{i};
                [x, y] = obj.ConvertPointsToPlot(outline(:,2), outline(:,1));
                lineWidth = 1;
                z = ones(numel(x),1) * 2;
                h(i) = line(x, y, z, 'Parent', axesid, 'Color', color, 'LineWidth', lineWidth, 'HitTest', 'off');
            end
    end
    obj.CellGraphics = h;
end





