function DrawFeatures(obj)

graphics = obj.FeatureGraphics;
if ~isempty(graphics)
    for i = 1:length(graphics)
        handles = graphics{i};
        if ~isempty(handles)
            delete(handles(ishandle(handles)));
        end
    end
end

if isempty(obj.RawDataSource) || ~obj.RawDataSource.HasFeatures
    obj.FeatureGraphics = [];
    return
end

list = obj.RawDataSource.FeatureList;
graphics = cell(list.Count, 1);
axesid = obj.AxesID;
for i = 1:list.Count
    feature = list.ElementAt(i);
    graphics{i} = feature.Draw(axesid, obj);
end
obj.FeatureGraphics = graphics;