function handled = OnCommand(obj, command, varargin)

handled = true;
import siman.*;
switch command
    case 'ZoomIn'
        ZoomIn(obj);
    case 'ZoomOut'
        ZoomOut(obj);
    case 'LockPlot'
        LockPlot(obj);
    case 'ShowColorbar'
        ShowColorbar(obj);
    case 'CopyFullImage'
        CopyFullImage(obj);
    case 'CopyVisibleImage'
        CopyVisibleImage(obj);
    case 'SaveFullImageAs'
        SaveFullImageAs(obj);
    case 'SaveVisibleImageAs'
        SaveVisibleImageAs(obj);
    case 'SaveImageStackAs'
        SaveImageStackAs(obj);
    case 'CopyData'
        CopyData(obj);
    case 'SaveDataAs'
        SaveDataAs(obj);
    case 'MakeMovie'
        MakeMovie(obj);
    otherwise
        handled = false;
end
end

function ZoomIn(obj)
    zoom = obj.Zoom;
    offset = obj.ViewWindowOffset;
    obj.Zoom = zoom * 2;
    obj.ViewWindowOffset = offset * 2;
    obj.QueueRedraw();
end

function ZoomOut(obj)
    zoom = obj.Zoom;
    offset = obj.ViewWindowOffset;
    obj.Zoom = zoom / 2;
    obj.ViewWindowOffset = offset / 2;
    obj.QueueRedraw();
end

function LockPlot(obj)
    obj.IsLocked = ~obj.IsLocked;
end

function ShowColorbar(obj)
    obj.ShowColorbar = ~obj.ShowColorbar;
end

function SaveDataAs(obj)
    siman.FileIOHelper.SaveImageFile(obj.ProcessedData, obj, 'LastSavedImage');
end

function CopyData(obj)
    CopyImage(obj, obj.ProcessedData);
end

function SaveFullImageAs(obj)
    im = CreateRGBImage(obj, obj.FullImage);
    siman.FileIOHelper.SaveImageFile(im, obj, 'LastSavedImage');
end

function SaveImageStackAs(obj)
    im = GetImageStack(obj, obj.ProcessedData);
    siman.FileIOHelper.SaveImageFile(im, obj, 'LastSavedImage');
end

function SaveVisibleImageAs(obj)
    im = GetVisibleImage(obj);
    siman.FileIOHelper.SaveImageFile(im, obj, 'LastSavedImage');
end

function CopyFullImage(obj)
    CopyFullImage(obj, obj.FullImage);
end

function CopyVisibleImage(obj)
    im = GetVisibleImage(obj);
    CopyImage(obj, im);
end

function CopyImage(obj, data)
    im = CreateRGBImage(obj, data);
    warndlg('Not implemented');
end

function im = GetVisibleImage(obj)
    xRange = round(obj.ViewImageXRange);
    yRange = round(obj.ViewImageYRange);
    rect = [xRange(1) yRange(1) diff(xRange) diff(yRange)];
    frame = getframe(obj.AxesID);
    [im, cmap] = frame2im(frame);
    if ~isempty(cmap)
        im = ind2rgb(im, cmap);
    end
    % Must remove whitespace around actual image data
    dim = size(im);
    trace = mean(im(:,:,1), 1);
    if trace(1) == 255
        start = find(trace ~= 255, 1, 'first') + 1;
        stop = dim(2) - start + 1;
        im = im(:, start:stop, :);
    end
    trace = mean(im(:,:,1), 2);
    if trace(1) == 255
        start = find(trace ~= 255, 1, 'first') + 1;
        stop = dim(1) - start + 1;
        im = im(start:stop, :, :);
    end
end

function im = GetImageStack(obj, data)
    if isempty(data)
        im = [];
        return
    end
    if islogical(data)
        im.Colormap = [0 0 0; 255 255 255];
        im.Data = ind2rgb(double(data) + 1, im.Colormap);        
    else
        cmapname = obj.Colormap;
        cmap = colormap(cmapname);
        cmapSize = numel(cmap)/3;
        limits = [obj.ColorLimActual_Lower obj.ColorLimActual_Upper];
        data = map2range(data, [0 cmapSize-1], limits);
        %range = limits(2) - limits(1);
        %data = min(range, max(0, data - limits(1)))/range * (numel(cmap)/3 - 1) + 1;
        im.Data = uint8(data);
    end
end

function im = CreateRGBImage(obj, data)
    if isempty(data)
        im = [];
        return
    end
    if islogical(data)
        cmap = [0 0 0; 255 255 255];
        im = ind2rgb(double(data) + 1, cmap);        
    elseif length(size(data)) == 2
        cmapname = obj.Colormap;
        cmap = colormap(cmapname);
        limits = [obj.ColorLimActual_Lower obj.ColorLimActual_Upper];
        range = limits(2) - limits(1);
        data = min(range, max(0, data - limits(1)))/range * (numel(cmap)/3 - 1) + 1;
        data = uint8(data);
        im = ind2rgb(data, cmap);
    else
        im = data;
    end
end

function MakeMovie(obj)
    filename = siman.FileIOHelper.ChooseOutputFile({'*.avi', 'AVI Files'}, obj, 'LastSavedMovie');
    if isempty(filename)
        return
    end

    data = obj.ProcessedData;
    if isempty(data)
        return % Shouldn't happen, but check
    end
    dim = size(data);
    xRange = round(obj.ViewImageXRange);
    yRange = round(obj.ViewImageYRange);
    if yRange(1) ~= 1 || yRange(2) ~= dim(1) || xRange(1) ~= 1 || xRange(2) ~= dim(2)
        data = data(yRange(1):yRange(2), xRange(1):xRange(2), :);
    end
    params.Colormap = colormap(obj.AxesID);
    params.CLim = [obj.ColorLimActual_Lower, obj.ColorLimActual_Upper];
    makeavi(filename, data, params); %TODO add params
end


