classdef ImagePropPanel < siman.ToolPanel
    % ImagePropPanel
    methods
        % Constructor
        function obj = ImagePropPanel(parent)
            obj@siman.ToolPanel(parent);
        end
        
        function InitDefaults(obj)
            obj.Name = 'Image Properties';
            obj.Size = [260 220];
            obj.DockedLocation = 'east';
        end
        
        function InitPanel(obj)
            InitPanel@siman.ToolPanel(obj);
        end
        
        function OnAttachedPlotChanged(obj, type)
            obj.QueueLayout();
        end
                
        function OnPlotPropertyChanged(obj, src, evt)
            obj.QueueRedraw();
        end
        
        function OnPlotPropertyLayoutChanged(obj, src, evt)
            obj.QueueLayout();
        end
        
        function source = GetPanelDataSource(obj)
            source = obj.CurrentAttachedPlot;
        end
        
        function ResetLayout(obj)
            obj.MakeControls();
        end
    end
end


