function MakeControls(obj)

import siman.*;
parentPanel = obj.PanelID;
margin = siman.UIHelper.PANEL_MARGIN;
pos = get(parentPanel, 'Position');
top = pos(4)-margin-siman.UIHelper.PANEL_TOP_OFFSET;
source = obj.CurrentAttachedPlot;

children = get(parentPanel, 'Children');
delete(children);

controlParams.ParentPanel = parentPanel;
controlParams.DataObject = source;
controlParams.Controller = source;

location = [margin top];

if isempty(source)
    siman.UIHelper.MakeLabel(['No image plot'], ...
                    location, controlParams);
    return
end

controlParams.Width = 100;
location = siman.UIHelper.MakeLabeledPopup('Direction', 'Direction:', ...
    location, controlParams);

location(2) = location(2) - 10;

controlParams.Width = 100;
location = siman.UIHelper.MakeLabeledPopup('Colormap', 'Colormap:', ...
    location, controlParams);

location(2) = location(2) - 10;

controlParams.Width = 130;
location = siman.UIHelper.MakeLabeledPopup('ColorLimMode', 'Color limit mode:', ...
    location, controlParams);


switch source.ColorLimMode
    case 'auto'
    case 'manual'
        controlParams.Width = 50;
        sideLocation = location;
        [location, h] = siman.UIHelper.MakeLabeledTextbox('ColorLim_Lower', '   Color lim:', ...
            location, controlParams);

        pos = get(h, 'Position');
        sideLocation(1) = pos(1) + pos(3);
        controlParams.Width = 50;
        siman.UIHelper.MakeLabeledTextbox('ColorLim_Upper', ' to ', ...
            sideLocation, controlParams);
        
    case 'manual percent'
        controlParams.Width = 40;
        sideLocation = location;
        [location, h] = siman.UIHelper.MakeLabeledTextbox('ColorPercentLim_Lower', '   Color % lim:', ...
            location, controlParams);

        pos = get(h, 'Position');
        sideLocation(1) = pos(1) + pos(3);
        controlParams.Width = 40;
        siman.UIHelper.MakeLabeledTextbox('ColorPercentLim_Upper', ' to ', ...
            sideLocation, controlParams);
        
    case 'manual percentile'
        controlParams.Width = 40;
        sideLocation = location;
        [location, h] = siman.UIHelper.MakeLabeledTextbox('ColorPercentileLim_Lower', '   Color %tile lim:', ...
            location, controlParams);

        pos = get(h, 'Position');
        sideLocation(1) = pos(1) + pos(3);
        controlParams.Width = 40;
        siman.UIHelper.MakeLabeledTextbox('ColorPercentileLim_Upper', ' to ', ...
            sideLocation, controlParams);
end

sideLocation = location;
if ~strcmp(source.ColorLimMode, 'manual')
    controlParams.Width = 40;
    [location, h] = siman.UIHelper.MakeLabeledIndicator('ColorLimActual_Lower', '   Actual range:   ', ...
        location, controlParams);

    pos = get(h, 'Position');
    sideLocation(1) = pos(1) + pos(3);
    controlParams.Width = 40;
    siman.UIHelper.MakeLabeledIndicator('ColorLimActual_Upper', ' to ', ...
        sideLocation, controlParams);
end
